% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topDCGenes.R
\name{topDCGenes}
\alias{topDCGenes}
\title{Ranks genes by their total number of differentially correlated gene pairs.}
\usage{
topDCGenes(ddcor_res, adjusted = FALSE, pval_gene_thresh = 0.05,
  geneNameCol = c("Gene1", "Gene2"), nGenes = "all", classes = TRUE)
}
\arguments{
\item{ddcor_res}{The table of differential correlations outputted from ddcor. Expected to have pValDiff or pValDiff_adj columns as well as zScoreDiff, Gene1, +/- Classes columns.}

\item{adjusted}{Logical indicating whether adjusted p-values from the differential correlation table (i.e., column "pValDiff_adj", when adjusted = TRUE) or unadjusted p-values (i.e., column "pValDiff", when adjusted = FALSE) should be used to subset the table into significant and non-significant portions.}

\item{pval_gene_thresh}{p-value threshold to call a gene as having significant differential correlation or not.}

\item{geneNameCol}{Character vector specifying the name of the columns that are used to extract the gene symbols. Note that the default is c("Gene1", "Gene2"), but this only makes sense in the context of a full DGCA experiment. In the case of a splitSet, you may want to use "Gene1" to avoid counting the splitSet names in all of the categories.}

\item{nGenes}{Number of genes to display in the resulting table. Default = "all", but also can be restricted to a particular number.}

\item{classes}{Gets the number of differentially correlated gene pairs associated with each of the differential correlation classes.}
}
\value{
A data frame with corresponding lists of genes most associated with each of the directions and/or correlation classes.
}
\description{
Returns list of lists for the top differentially correlated gene pairs in each direction and/or class.
}
\examples{
data(darmanis); data(design_mat); darmanis_subset = darmanis[1:30, ]
ddcor_res = ddcorAll(inputMat = darmanis_subset, design = design_mat,
 compare = c("oligodendrocyte", "neuron"))
top_genes = topDCGenes(ddcor_res)
}

