% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploid.utils.R
\docType{import}
\name{reexports}
\alias{reexports}
\alias{extractCoverageFromTxt}
\alias{extractCoverageFromVcf}
\alias{extractPLAF}
\alias{plotProportions}
\alias{plotAltVsRef}
\alias{histWSAF}
\alias{plotWSAFvsPLAF}
\alias{plotObsExpWSAF}
\alias{computeObsWSAF}
\alias{haplotypePainter}
\title{Extract read counts from plain text file}
\arguments{
\item{refFileName}{Path of the reference allele count file.}

\item{altFileName}{Path of the alternative allele count file.}

\item{vcfFileName}{Path of the VCF file.}

\item{ADFieldIndex}{Index of the AD field of the sample field. For example,
if the format is "GT:AD:DP:GQ:PL", the AD index is 2 (by default).}

\item{plafFileName}{Path of the PLAF text file.}

\item{proportions}{Matrix of the MCMC proportion samples. The matrix size is
number of the MCMC samples by the number of strains.}

\item{exclude.ref}{Numeric array of reference allele count at sites that are
not deconvoluted.}

\item{exclude.alt}{Numeric array of alternative allele count at sites that
are not deconvoluted}

\item{exclusive}{When TRUE 0 < WSAF < 1; otherwise 0 <= WSAF <= 1.}

\item{plaf}{Numeric array of population level allele frequency.}

\item{potentialOutliers}{Index of potential outliers.}

\item{obsWSAF}{Numeric array of observed WSAF.}

\item{expWSAF}{Numeric array of expected WSAF.}

\item{cex.lab}{Label size.}

\item{cex.main}{Title size.}

\item{cex.axis}{Axis text size.}

\item{ref}{Numeric array of reference allele count.}

\item{alt}{Numeric array of alternative allele count.}

\item{posteriorProbabilities}{Posterior probabilities matrix with the size of
number of loci by the number of reference strain.}

\item{title}{Figure title.}

\item{labelScaling}{Scaling parameter for plotting.}

\item{numberOfInbreeding}{Number of inbreeding strains copying from.}
}
\value{
A data.frame contains four columns: chromosomes, positions, reference
 allele count, alternative allele count.

A data.frame contains four columns: chromosomes, positions, reference
 allele count, alternative allele count.

A numeric array of PLAF

histogram

Numeric array of observed allele frequency within sample.
}
\note{
The allele count files must be tab-delimited. The allele count files
 contain three columns: chromosomes, positions and allele count.

The VCF file should only contain one sample. If more samples present in
 the VCF, it only returns coverage for of the first sample.

The text file must have header, and population level allele frequency
 recorded in the "PLAF" field.
}
\examples{
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390 <- extractCoverageFromTxt(refFile, altFile)

vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390 <- extractCoverageFromVcf(vcfFile, "PG0390-C")

plafFile <- system.file("extdata", "labStrains.test.PLAF.txt",
  package = "DEploid"
)
plaf <- extractPLAF(plafFile)
\dontrun{
plafFile <- system.file("extdata", "labStrains.test.PLAF.txt",
  package = "DEploid"
)
panelFile <- system.file("extdata", "labStrains.test.panel.txt",
  package = "DEploid"
)
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT <- extractCoverageFromTxt(refFile, altFile)
PG0390Coverage.deconv <- dEploid(paste(
  "-ref", refFile, "-alt", altFile,
  "-plaf", plafFile, "-noPanel"
))
plotProportions(PG0390Coverage.deconv$Proportions, "PG0390-C proportions")
}

# Example 1
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT <- extractCoverageFromTxt(refFile, altFile)
plotAltVsRef(PG0390CoverageT$refCount, PG0390CoverageT$altCount)

# Example 2
vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV <- extractCoverageFromVcf(vcfFile, "PG0390-C")
plotAltVsRef(PG0390CoverageV$refCount, PG0390CoverageV$altCount)

# Example 1
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390Coverage <- extractCoverageFromTxt(refFile, altFile)
obsWSAF <- computeObsWSAF(PG0390Coverage$altCount, PG0390Coverage$refCount)
histWSAF(obsWSAF)
myhist <- histWSAF(obsWSAF, FALSE)

# Example 2
vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV <- extractCoverageFromVcf(vcfFile, "PG0390-C")
obsWSAF <- computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
histWSAF(obsWSAF)
myhist <- histWSAF(obsWSAF, FALSE)

# Example 1
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT <- extractCoverageFromTxt(refFile, altFile)
obsWSAF <- computeObsWSAF(PG0390CoverageT$altCount, PG0390CoverageT$refCount)
plafFile <- system.file("extdata", "labStrains.test.PLAF.txt",
  package = "DEploid"
)
plaf <- extractPLAF(plafFile)
plotWSAFvsPLAF(plaf, obsWSAF)

# Example 2
vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV <- extractCoverageFromVcf(vcfFile, "PG0390-C")
obsWSAF <- computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
plafFile <- system.file("extdata", "labStrains.test.PLAF.txt",
  package = "DEploid"
)
plaf <- extractPLAF(plafFile)
plotWSAFvsPLAF(plaf, obsWSAF)


vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV <- extractCoverageFromVcf(vcfFile, "PG0390-C")
obsWSAF <- computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
plafFile <- system.file("extdata", "labStrains.test.PLAF.txt",
  package = "DEploid"
)
PG0390.deconv <- dEploid(paste(
  "-vcf", vcfFile,
  "-plaf", plafFile, "-noPanel"
))
prop <- PG0390.deconv$Proportions[dim(PG0390.deconv$Proportions)[1], ]
expWSAF <- t(PG0390.deconv$Haps) \%*\% prop
plotObsExpWSAF(obsWSAF, expWSAF)

# Example 1
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390CoverageT <- extractCoverageFromTxt(refFile, altFile)
obsWSAF <- computeObsWSAF(PG0390CoverageT$altCount, PG0390CoverageT$refCount)

# Example 2
vcfFile <- system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV <- extractCoverageFromVcf(vcfFile, "PG0390-C")
obsWSAF <- computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)

}
\seealso{
\code{\link{histWSAF}} for histogram.
}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{DEploid.utils}{\code{\link[DEploid.utils]{computeObsWSAF}}, \code{\link[DEploid.utils]{extractCoverageFromTxt}}, \code{\link[DEploid.utils]{extractCoverageFromVcf}}, \code{\link[DEploid.utils]{extractPLAF}}, \code{\link[DEploid.utils]{haplotypePainter}}, \code{\link[DEploid.utils]{histWSAF}}, \code{\link[DEploid.utils]{plotAltVsRef}}, \code{\link[DEploid.utils]{plotObsExpWSAF}}, \code{\link[DEploid.utils]{plotProportions}}, \code{\link[DEploid.utils]{plotWSAFvsPLAF}}}
}}

