% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEET_Input_as_Reference.R
\name{DEET_Input_as_Reference}
\alias{DEET_Input_as_Reference}
\title{DEET_Input_as_Reference}
\usage{
DEET_Input_as_Reference(genes, DEET_dataset, background = NULL)
}
\arguments{
\item{genes}{A character vector of gene symbols within `DEET_dataset`}

\item{DEET_dataset}{The databank of the differential expression enrichment tool.
Appropriate inputs here are "DEET_example_data" stored within DEET, the "DEET_combined.rda" file
from the DEET stable repositoy found at X, and the DEET database developmental repository found at Y.
The DEET_dataset is a named list where details of it's structure can be found ?DEET_example_data.
Unlike in DEET_enrich, this dataset does not require the pathway-relevant elements
of the DEET_dataset list, namely "gmt_BP", or "gmt_TF" "DEET_gmt_BP",  "DEET_gmt_TF".
It also does not need DEET_gmt_DE.}

\item{background}{Character vector of human gene symbols showing all
possible genes. Default value is NULL and the background is generated
as all detected DEGs across any comparison.}
}
\value{
Named list containing the ActivePathways enrichment of each comparison
on the user's inputted gene list, as well as the associated metadata of 
each enriched comparison.
}
\description{
Alternative function to DEET enrich for when the inputted gene
list is unordered. Here, we can increase the statistical rigour of enrichment
by levaraging the p-values of the DEGs within DEET. Specifically, the inputted
DE list is used as the reference and we test each DE list against your reference.
Specifically. We convert your reference into a gmt file before inputting each pairwise
DE list into ActivePathways. This function does not complete correlations or pathway-level
analysis.
}
\examples{

data("example_DEET_enrich_input")
genes <- rownames(example_DEET_enrich_input)
data("DEET_example_data")
DEET_out_ref <- DEET_Input_as_Reference(genes, DEET_dataset = DEET_example_data)


}
\references{
Paczkowska M, Barenboim J, Sintupisut N, et al. Integrative pathway
enrichment analysis of multivariate omics data. Nat Commun. 2020;11(1):735.
doi:10.1038/s41467-019-13983-9
}
\author{
Dustin Sokolowski
}
