% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/henon.sim.R
\name{henon.sim}
\alias{henon.sim}
\title{Simulates time-series data from the Henon map}
\usage{
henon.sim(
  a = 1.4,
  b = 0.3,
  s = 0,
  x0 = runif(1, -0.5, 0.5),
  y0 = runif(1, -0.5, 0.5),
  n = 1000,
  n.start = 50
)
}
\arguments{
\item{a}{a non-negative integer denoting the value of parameter \code{a} (Default 1.4).}

\item{b}{a non-negative integer denoting the value of parameter \code{b} (Default 0.3).}

\item{s}{a non-negative integer denoting the variance value of the error term. If \eqn{s=0} gives the standard deterministic map (Default 0).}

\item{x0}{a non-negative integer denoting the initial condition of x-coordinate (Default random number between -0.5 and 0.5).}

\item{y0}{a non-negative integer denoting the initial condition of y-coordinate (Default random number between -0.5 and 0.5).}

\item{n}{a non-negative integer denoting the length (Default 1000).}

\item{n.start}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values are in the attractor (Default 50).}
}
\value{
A time-series data object generated from the Henon map with or without an additive measurement noise term. This dataset could be useful for researchers interested in the field of chaotic dynamic systems and non-linear time series analysis and professors (and students) who teach (learn) courses related to those topics.
}
\description{
This function simulates time-series data from the Henon map considering the parameter set selected by the user. The initial condition is a random number between -0.5 and 0.5. Some initial conditions may lead to an unstable system that will tend to infinity.
}
\note{
This function provides also noisy time-series data from the deterministic henon map adding an additive measurement noise term if \eqn{s>0}. We have added to each time-series data a normal multinomial error term denoted by \eqn{{\varepsilon _t} \sim N\left( {0,s} \right)} with different variance values (\eqn{s}). In this sense we have considered it appropriate to add a measurement noise term because most real-world observed time-series data are usually noise-contaminated signals, characterised by an erratic and persistent volatility in certain periods and there is almost always a source of noise linked to measurement errors in real-world datasets.
}
\examples{
## set.seed(34)
## Simulates time-series data from the deterministic henon map
## with a chaotic behaviour.
ts <- henon.sim(a = 1.4, b = 0.3, s = 0, n = 1000)
##
## Simulates time-series data from the deterministic henon map
## with a non-chaotic behaviour.
ts <- henon.sim(a = 1.2, b = 0.1, s = 0, n = 1000)
}
\references{
Hénon, M. 1976 A two-dimensional mapping with a strange attractor. Communications in Mathematical Physics 50(1):69-77.
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
