% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-DBIResult.R, R/07-DBIResultArrow.R
\docType{class}
\name{DBIResult-class}
\alias{DBIResult-class}
\alias{DBIResultArrow-class}
\alias{DBIResultArrowDefault-class}
\title{DBIResult class}
\description{
This virtual class describes the result and state of execution of
a DBMS statement (any statement, query or non-query).  The result set
keeps track of whether the statement produces output how many rows were
affected by the operation, how many rows have been fetched (if statement is
a query), whether there are more rows to fetch, etc.
}
\section{Implementation notes}{

Individual drivers are free to allow single or multiple
active results per connection.

The default show method displays a summary of the query using other
DBI generics.
}

\seealso{
Other DBI classes: 
\code{\link{DBIConnection-class}},
\code{\link{DBIConnector-class}},
\code{\link{DBIDriver-class}},
\code{\link{DBIObject-class}}

Other DBIResult generics: 
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbColumnInfo}()},
\code{\link{dbFetch}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetRowCount}()},
\code{\link{dbGetRowsAffected}()},
\code{\link{dbGetStatement}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbQuoteLiteral}()},
\code{\link{dbQuoteString}()},
\code{\link{dbUnquoteIdentifier}()}
}
\concept{DBI classes}
\concept{DBIResult generics}
