% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{dbUnquoteIdentifier}
\alias{dbUnquoteIdentifier}
\title{Unquote identifiers}
\usage{
dbUnquoteIdentifier(conn, x, ...)
}
\arguments{
\item{conn}{A subclass of \linkS4class{DBIConnection}, representing
an active connection to an DBMS.}

\item{x}{An \link{SQL} or \link{Id} object or character vector, or a list of such
objects, to unquote.}

\item{...}{Other arguments passed on to methods.}
}
\description{
Call this method to convert a \link{SQL} object created by \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
back to a list of \link{Id} objects.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbUnquoteIdentifier")}
}
\examples{
# Unquoting allows to understand the structure of a
# possibly complex quoted identifier
dbUnquoteIdentifier(
  ANSI(),
  SQL(c('"Schema"."Table"', '"UnqualifiedTable"'))
)

# The returned object is always a list,
# also for Id objects or lists thereof
dbUnquoteIdentifier(
  ANSI(),
  Id(schema = "Schema", table = "Table")
)

dbUnquoteIdentifier(
  ANSI(),
  list(Id(schema = "Schema", table = "Table"), Id(table = "UnqualifiedTable"))
)

# Lists of SQL objects can also be processed,
# but each component must be length 1
dbUnquoteIdentifier(
  ANSI(),
  list(SQL('"Schema"."Table"'), SQL('"UnqualifiedTable"'))
)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}},
  \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}}, \code{\link{dbQuoteString}}
}
\concept{DBIResult generics}
