% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_DAP.R
\name{classify_DAP}
\alias{classify_DAP}
\title{Classification via DAP}
\usage{
classify_DAP(xtrain, ytrain, xtest, V, prior = TRUE)
}
\arguments{
\item{xtrain}{A n x p training dataset; n observations on the rows and p features on the columns.}

\item{ytrain}{A n vector of training group labels, either 1 or 2.}

\item{xtest}{A m x p testing dataset; m observations on the rows and p features on the columns.}

\item{V}{A p x 2 projection matrix.}

\item{prior}{A logical indicating whether to put larger weights to the groups of larger size; the default value is \code{TRUE}.}
}
\value{
Predicted class labels for the test data.
}
\description{
Classify observations in the test set using the supplied matrix V and the training data.
}
\examples{
## This is an example for classify_DAP

## Generate data
n_train = 50
n_test = 50
p = 100
mu1 = rep(0, p)
mu2 = rep(3, p)
Sigma1 = diag(p)
Sigma2 = 0.5* diag(p)

## Build training data and test data
x1 = MASS::mvrnorm(n = n_train, mu = mu1, Sigma = Sigma1)
x2 = MASS::mvrnorm(n = n_train, mu = mu2, Sigma = Sigma2)
xtrain = rbind(x1, x2)
x1_test = MASS::mvrnorm(n = n_test, mu = mu1, Sigma = Sigma1)
x2_test = MASS::mvrnorm(n = n_test, mu = mu2, Sigma = Sigma2)
xtest = rbind(x1_test, x2_test)
ytrain = c(rep(1, n_train), rep(2, n_train))

# Standardize the data
out_s = standardizeData(xtrain, ytrain, center = FALSE)

## Find V
out.proj = solve_DAP_C(X1 = out_s$X1, X2 = out_s$X2, lambda = 0.3)
V = cbind(diag(1/out_s$coef1)\%*\%out.proj$V[,1],diag(1/out_s$coef2)\%*\% out.proj$V[,2])

# Predict y using classify_DAP
ypred = classify_DAP(xtrain, ytrain, xtest, V = V)

}
