% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{impCoef}
\alias{impCoef}
\title{Plot Variable Importance.}
\usage{
impCoef(obj, pct = FALSE, names = NULL, orderSize = TRUE)
}
\arguments{
\item{obj}{Any objct that permits prediction of model terms using the \code{predict(obj, type="terms")} syntax.}

\item{pct}{Logical indicating whether the entries should be percentagized by the 
total sum of squares in the predictions.}

\item{names}{An optional vector of names for the coefficients.}

\item{orderSize}{Logical indicating whether the terms are ordered by importance in the graph.}
}
\value{
Returns an initialized ggplot, but geometries need to be added to produce meaningful output (see examples).
}
\description{
Builds a plot of importance based on Silber, Rosenbaum and Ross's (1995)
idea of importance as the variance of the predicted model terms.
}
\examples{
data(aclp)
library(ggplot2)
mod <- glm(democ ~ log(gdpw) + popg +  year, data=aclp, family=binomial)	
impCoef(mod, pct=TRUE, names=c("GDP", "Population", "Year")) + 
geom_point(size=2)  +
labs(x="Importance", y="")


}
\references{
Silber, JH, PR Rosenbaum and RN Ross (1995) Comparing the Contributions of Groups of Predictors: Which Outcomes Vay with Hospital Rather than Patient Characteristics? JASS 90, 7-18.
}
