% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_loglik_integrate.R
\name{DAISIE_loglik_integrand}
\alias{DAISIE_loglik_integrand}
\title{Integrand to be integrated to calculate the log likelihood for the relaxed
rate model.}
\usage{
DAISIE_loglik_integrand(
  DAISIE_par,
  pars1,
  pars2,
  brts,
  stac,
  missnumspec,
  methode,
  abstolint,
  reltolint,
  verbose,
  pick,
  par_mean,
  par_sd
)
}
\arguments{
\item{DAISIE_par}{A numeric parameter to evaluate the integral of the
function.}

\item{pars1}{Vector of model parameters: \cr \cr \code{pars1[1]} corresponds
to lambda^c (cladogenesis rate) \cr \code{pars1[2]} corresponds to mu
(extinction rate) \cr \code{pars1[3]} corresponds to K (clade-level
carrying capacity) \cr \code{pars1[4]} corresponds to gamma
(immigration rate) \cr \code{pars1[5]} corresponds to lambda^a
(anagenesis rate).}

\item{pars2}{Vector of settings: \cr \cr \code{pars2[1]} corresponds to res,
the maximum number of endemics or non-endemics for which the ODE system is
solved; this must be much larger than the actual number for which the
probability needs to be calculated.) \cr \code{pars2[2]} corresponds to M,
size of the mainland pool, i.e the number of species that can potentially
colonize the island.}

\item{brts}{Numeric vector of branching times}

\item{stac}{Numeric of Endemicity status}

\item{missnumspec}{Numeric of missing species}

\item{methode}{Method of the ODE-solver. Supported Boost \code{ODEINT}
solvers (steppers) are:
\code{"odeint::runge_kutta_cash_karp54"}
\code{"odeint::runge_kutta_fehlberg78"}
\code{"odeint::runge_kutta_dopri5"}
\code{"odeint::bulirsch_stoer"}
without \code{odeint::}-prefix, \code{\link[deSolve]{ode}} method is
assumed. The default method overall is
\code{"lsodes"} for \code{\link{DAISIE_ML_CS}()}
and \code{"ode45"} from \code{\link[deSolve]{ode}()} for
\code{\link{DAISIE_ML_IW}()}.}

\item{abstolint}{Numeric absolute tolerance of the integration}

\item{reltolint}{Numeric relative tolerance of the integration}

\item{verbose}{A numeric vector of length 1, which in simulations and
`DAISIEdataprep()` can be `1` or `0`, where `1` gives intermediate output
should be printed.
For ML functions a numeric determining if intermediate output should be
printed. The default: `0` does not print, `1` prints the initial
likelihood and the settings that were selected (which parameters are
to be optimised, fixed or shifted), `2` prints the same as `1 and also the
intermediate output of the parameters and loglikelihood, while `3` the
same as `2` and prints intermediate progress during likelihood computation.}

\item{pick}{Numeric determining which parameter is selected for the
relaxed-rate model}
}
\value{
A numeric
}
\description{
Integrand to be integrated to calculate the log likelihood for the relaxed
rate model.
}
\keyword{internal}
