% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.trainFunctions.TrainFunction.R
\name{TrainFunction}
\alias{TrainFunction}
\title{Control parameters for train stage.}
\description{
Abstract class used as template to define customized functions
to control the computational nuances of train function.
}
\seealso{
\code{\link{TwoClass}}
}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TrainFunction$new()}}
\item \href{#method-create}{\code{TrainFunction$create()}}
\item \href{#method-getResamplingMethod}{\code{TrainFunction$getResamplingMethod()}}
\item \href{#method-getNumberFolds}{\code{TrainFunction$getNumberFolds()}}
\item \href{#method-getSavePredictions}{\code{TrainFunction$getSavePredictions()}}
\item \href{#method-getClassProbs}{\code{TrainFunction$getClassProbs()}}
\item \href{#method-getAllowParallel}{\code{TrainFunction$getAllowParallel()}}
\item \href{#method-getVerboseIter}{\code{TrainFunction$getVerboseIter()}}
\item \href{#method-getTrFunction}{\code{TrainFunction$getTrFunction()}}
\item \href{#method-getMeasures}{\code{TrainFunction$getMeasures()}}
\item \href{#method-getType}{\code{TrainFunction$getType()}}
\item \href{#method-getSeed}{\code{TrainFunction$getSeed()}}
\item \href{#method-setSummaryFunction}{\code{TrainFunction$setSummaryFunction()}}
\item \href{#method-setClassProbs}{\code{TrainFunction$setClassProbs()}}
\item \href{#method-clone}{\code{TrainFunction$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Function used to initialize the object parameters during
execution time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$new(
  method,
  number,
  savePredictions,
  classProbs,
  allowParallel,
  verboseIter,
  seed
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{The resampling method: "boot", "boot632", "optimism_boot",
"boot_all", "cv", "repeatedcv", "LOOCV", "LGOCV" (for repeated
training/test splits), "none" (only fits one model to the entire training
set), "oob" (only for random forest, bagged trees, bagged earth, bagged
flexible discriminant analysis, or conditional tree forest models),
timeslice, "adaptive_cv", "adaptive_boot" or "adaptive_LGOCV"}

\item{\code{number}}{Either the number of folds or number of resampling
iterations}

\item{\code{savePredictions}}{An indicator of how much of the hold-out
predictions for each resample should be saved. Values can be either
"all", "final", or "none". A logical value can also be used that convert
to "all" (for true) or "none" (for false). "final" saves the predictions
for the optimal tuning parameters.}

\item{\code{classProbs}}{A \link{logical} value. Should class probabilities be
computed for classification models (along with predicted values) in each
resample?}

\item{\code{allowParallel}}{A \link{logical} value. If a parallel backend is
loaded and available, should the function use it?}

\item{\code{verboseIter}}{A \link{logical} for printing a training log.}

\item{\code{seed}}{An optional \link{integer} that will be used to set the seed
during model training stage.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create"></a>}}
\if{latex}{\out{\hypertarget{method-create}{}}}
\subsection{Method \code{create()}}{
Creates a \code{\link[caret]{trainControl}} requires for the
training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$create(summaryFunction, search.method = "grid", class.probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{summaryFunction}}{An object inherited from
\code{\link{SummaryFunction}} class.}

\item{\code{search.method}}{Either "grid" or "random", describing how the tuning
parameter grid is determined.}

\item{\code{class.probs}}{A \link{logical} indicating if class probabilities
should be computed for classification models (along with predicted values)
in each resample.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getResamplingMethod"></a>}}
\if{latex}{\out{\hypertarget{method-getResamplingMethod}{}}}
\subsection{Method \code{getResamplingMethod()}}{
Returns the resampling method used during training staged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getResamplingMethod()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector or length 1 or \link{NULL}
if not defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNumberFolds"></a>}}
\if{latex}{\out{\hypertarget{method-getNumberFolds}{}}}
\subsection{Method \code{getNumberFolds()}}{
Returns the number or folds or number of iterations used
during training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getNumberFolds()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \link{integer} vector or length 1 or \link{NULL} if not
defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSavePredictions"></a>}}
\if{latex}{\out{\hypertarget{method-getSavePredictions}{}}}
\subsection{Method \code{getSavePredictions()}}{
Indicates if the predictions for each resample should be
saved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getSavePredictions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value or \link{NULL} if not defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClassProbs"></a>}}
\if{latex}{\out{\hypertarget{method-getClassProbs}{}}}
\subsection{Method \code{getClassProbs()}}{
Indicates if class probabilities should be computed for
classification models in each resample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getClassProbs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getAllowParallel"></a>}}
\if{latex}{\out{\hypertarget{method-getAllowParallel}{}}}
\subsection{Method \code{getAllowParallel()}}{
Determines if model training is performed in parallel.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getAllowParallel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value. \link{TRUE} indicates parallelization is
enabled and \link{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getVerboseIter"></a>}}
\if{latex}{\out{\hypertarget{method-getVerboseIter}{}}}
\subsection{Method \code{getVerboseIter()}}{
Determines if training log should be printed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getVerboseIter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value. \link{TRUE} indicates training log is
enabled and \link{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTrFunction"></a>}}
\if{latex}{\out{\hypertarget{method-getTrFunction}{}}}
\subsection{Method \code{getTrFunction()}}{
Function used to return the
\code{\link[caret]{trainControl}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getTrFunction()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link[caret]{trainControl}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMeasures"></a>}}
\if{latex}{\out{\hypertarget{method-getMeasures}{}}}
\subsection{Method \code{getMeasures()}}{
Returns the measures used to optimize model hyperparameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getMeasures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getType"></a>}}
\if{latex}{\out{\hypertarget{method-getType}{}}}
\subsection{Method \code{getType()}}{
Obtains the type of classification problem ("Bi-class" or
"Multi-class").
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector with length 1. Either "Bi-class"
or "Multi-class".
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSeed"></a>}}
\if{latex}{\out{\hypertarget{method-getSeed}{}}}
\subsection{Method \code{getSeed()}}{
Indicates seed used during model training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$getSeed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \link{integer} value or \link{NULL} if not defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSummaryFunction"></a>}}
\if{latex}{\out{\hypertarget{method-setSummaryFunction}{}}}
\subsection{Method \code{setSummaryFunction()}}{
Function used to change the \code{\link{SummaryFunction}}
used in the training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$setSummaryFunction(summaryFunction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{summaryFunction}}{An object inherited from
\code{\link{SummaryFunction}} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setClassProbs"></a>}}
\if{latex}{\out{\hypertarget{method-setClassProbs}{}}}
\subsection{Method \code{setClassProbs()}}{
The function allows changing the class computation
capabilities.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$setClassProbs(class.probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class.probs}}{A \link{logical} indicating if class probabilities
should be computed for classification models (along with predicted values)
in each resample}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainFunction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
