% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPADE-class.R
\docType{class}
\name{SPADE-class}
\alias{SPADE-class}
\title{S4 SPADE Class}
\value{
A SPADE advanced analysis object
}
\description{
A SPADE object that holds pertinent SPADE advanced analysis run information.
This class should never be called explicitly. If a user would like to create a new Cytobank SPADE object, utilize the \link{spade.new} function.
}
\section{Slots}{

\describe{
\item{\code{down_sampled_events_target}}{numeric representing the percent of downsampling occurring within the SPADE analysis, \href{https://support.cytobank.org/hc/en-us/articles/115000597188-How-to-Configure-and-Run-a-SPADE-Analysis#Downsampling-Target}{learn more about SPADE density-dependent downsampling}}

\item{\code{fold_change_groups}}{dataframe representing the fold change groups within a SPADE analysis, \href{https://support.cytobank.org/hc/en-us/articles/206145497-SPADE-with-fold-change-overview-setup-and-analysis}{learn more about SPADE fold change groups}}

\item{\code{population_id}}{numeric representing the population to run the SPADE analysis on, \href{https://support.cytobank.org/hc/en-us/articles/115000597188-How-to-Configure-and-Run-a-SPADE-Analysis#Selecting-a-Population}{learn more about choosing a population for SPADE}}

\item{\code{spade_id}}{numeric representing the SPADE analysis ID}

\item{\code{target_number_nodes}}{numeric representing how many population nodes SPADE will seek out within the given data, \href{https://support.cytobank.org/hc/en-us/articles/115000597188-How-to-Configure-and-Run-a-SPADE-Analysis#Target-Number-of-Nodes}{learn more about target number of nodes for SPADE}}
}}

