% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytopt_desasc.R
\name{cytopt_desasc_r}
\alias{cytopt_desasc_r}
\title{Function to estimate the type cell proportions in an unclassified cytometry data set denoted X_s
by using the classification Lab_source from an other cytometry data set X_s. With this function
the computation of the estimate of the class proportions is done with a descent ascent algorithm.}
\usage{
cytopt_desasc_r(
  X_s,
  X_t,
  Lab_source,
  theta_true = NULL,
  eps = 1e-04,
  n_out = 5000,
  n_stoc = 10,
  step_grad = 10,
  monitoring = FALSE
)
}
\arguments{
\item{X_s}{a cytometry dataframe. The columns correspond to the different biological markers tracked.
One line corresponds to the cytometry measurements performed on one cell. The classification
of this Cytometry data set must be provided with the Lab_source parameters.}

\item{X_t}{a cytometry dataframe. The columns correspond to the different biological markers tracked.
One line corresponds to the cytometry measurements performed on one cell. The CytOpT algorithm
targets the cell type proportion in this Cytometry data set}

\item{Lab_source}{a vector of length \code{n} Classification of the X_s cytometry data set}

\item{theta_true}{If available, gold-standard proportions in the target data 
set \code{X_t} derived from manual gating. It allows to assess the gap between 
the estimate and the gold-standard. Default is \code{NULL}, in which case no 
assessment is performed.}

\item{eps}{an float value of regularization parameter of the Wasserstein distance. Default is \code{1e-04}.}

\item{n_out}{an integer number of iterations in the outer loop. This loop corresponds to the gradient
descent algorithm to minimize the regularized Wasserstein distance between the source and
target data sets. Default is \code{5000}.}

\item{n_stoc}{an integer number of iterations in the inner loop. This loop corresponds to the stochastic
algorithm that approximates a maximizer of the semi-dual problem. Default is \code{10}.}

\item{step_grad}{an integer number step size of the gradient descent algorithm 
of the outer loop. Default is \code{10}.}

\item{monitoring}{boolean indicating whether Kullback-Leibler divergence should be 
monitored and store throughout the optimization iterations. Default is \code{FALSE}.}
}
\value{
A list with the following elements:\code{h_hat}
}
\description{
Function to estimate the type cell proportions in an unclassified cytometry data set denoted X_s
by using the classification Lab_source from an other cytometry data set X_s. With this function
the computation of the estimate of the class proportions is done with a descent ascent algorithm.
}
