% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot_prop.R
\name{barplot_prop}
\alias{barplot_prop}
\title{Function to display a bland plot in order to visually assess the agreement between CytOpt estimation
of the class proportions and the estimate of the class proportions provided through manual gating.}
\usage{
barplot_prop(proportions, title = "", xaxis_angle = 45)
}
\arguments{
\item{proportions}{\code{data.frame} of (true and) estimated proportions from \code{CytOpt()}}

\item{title}{plot title. Default is \code{""}, i.e. no title.}

\item{xaxis_angle}{scalar indicating an angle to tilt the labels of x_axis. Default is \code{45}.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Function to display a bland plot in order to visually assess the agreement between CytOpt estimation
of the class proportions and the estimate of the class proportions provided through manual gating.
}
\examples{
if(interactive()){

res <- CytOpT(X_s = HIPC_Stanford_1228_1A, X_t = HIPC_Stanford_1369_1A, 
             Lab_source = HIPC_Stanford_1228_1A_labels,
             eps = 0.0001, lbd = 0.0001, n_iter = 10000, n_stoc=10,
             step_grad = 10, step = 5, power = 0.99, 
             method='minmax')
barplot_prop(res$proportions)

}
}
