% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovMean.R
\name{CovMean}
\alias{CovMean}
\title{Estimate Mean Covariance Matrix}
\usage{
CovMean(
  A,
  method = c("AIRM", "Cholesky", "Euclidean", "LERM", "Procrustes.SS",
    "Procrustes.Full", "PowerEuclidean", "RootEuclidean"),
  power = 1
)
}
\arguments{
\item{A}{a \eqn{(p\times p\times N)} 3d array of \eqn{N} SPD matrices.}

\item{method}{the type of distance measures to be used; \code{"AIRM"} for Affine Invariant
Riemannian Metric,
\code{"Cholesky"} for Cholesky difference in Frobenius norm,
\code{"Euclidean"} for naive Frobenius norm as distance,
\code{"LERM"} for Log Euclidean Riemannian Metric,
\code{"Procrustes.SS"} for Procrustes Size and Shape measure,
\code{"Procrustes.Full"} for Procrustes analysis with scale,
\code{"PowerEuclidean"} for weighted eigenvalues by some exponent, and
\code{"RootEuclidean"} for matrix square root.}

\item{power}{a non-zero number for PowerEuclidean distance.}
}
\value{
a \eqn{(p\times p)} mean covariance matrix estimated.
}
\description{
For a given 3-dimensional array where symmetric positive definite (SPD) matrices are stacked slice
by slice, it estimates Frechet mean on an open cone of SPD matrices under corresponding metric/distance
measure.
}
\examples{
\dontrun{
## generate 100 sample covariances of size (5-by-5).
pdim    = 5
samples = samplecovs(100,pdim)

## compute mean of first 50 sample covariances from data under Normal(0,Identity).
mLERM = CovMean(samples[,,1:50], method="LERM")
mAIRM = CovMean(samples[,,1:50], method="AIRM")
mChol = CovMean(samples[,,1:50], method="Cholesky")
mRoot = CovMean(samples[,,1:50], method="RootEuclidean")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(mLERM[,pdim:1], main="LERM mean")
image(mAIRM[,pdim:1], main="AIRM mean")
image(mChol[,pdim:1], main="Cholesky mean")
image(mRoot[,pdim:1], main="RootEuclidean mean")
par(opar)
}

}
\references{
\insertRef{dryden_non-euclidean_2009}{CovTools}
}
