% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovMean.R
\name{CovMean}
\alias{CovMean}
\title{Estimate Mean Covariance Matrix}
\usage{
CovMean(A, method = c("A", "C", "E", "L", "PS", "PF", "PE", "RE"), power = 1)
}
\arguments{
\item{A}{a \eqn{(p\times p\times N)} 3d array of \eqn{N} SPD matrices.}

\item{method}{the type of distance measures to be used;
\describe{
\item{\code{"A"}}{(AIRM) Affine Invariant Riemannian Metric}
\item{\code{"C"}}{(Cholesky) Cholesky difference in Frobenius norm}
\item{\code{"E"}}{(Euclidean) naive Frobenius norm as distance}
\item{\code{"L"}}{(LERM) Log Euclidean Riemannian Metric}
\item{\code{"PS"}}{(Procrustes.SS) Procrustes Size and Shape measure}
\item{\code{"PF"}}{(Procrustes.Full) Procrustes analysis with scale}
\item{\code{"PE"}}{(PowerEuclidean) weighted eigenvalues by some exponent}
\item{\code{"RE"}}{(RootEuclidean) matrix square root}
}}

\item{power}{a non-zero number for PowerEuclidean distance.}
}
\value{
a \eqn{(p\times p)} mean covariance matrix estimated.
}
\description{
For a given 3-dimensional array where symmetric positive definite (SPD) matrices are stacked slice
by slice, it estimates Frechet mean on an open cone of SPD matrices under corresponding metric/distance
measure.
}
\examples{
\dontrun{
## generate 50 sample covariances of size (10-by-10).
pdim    = 10
samples = samplecovs(50,pdim)

## compute means of first 50 sample covariances from data under Normal(0,Identity).
mA = CovMean(samples, method="A")
mC = CovMean(samples, method="C")
mE = CovMean(samples, method="E")
mL = CovMean(samples, method="L")
mPS = CovMean(samples, method="PS")
mPF = CovMean(samples, method="PF")
mPE = CovMean(samples, method="PE")
mRE = CovMean(samples, method="RE")

#' ## visualize
opar <- par(mfrow=c(3,3), pty="s")
image(diag(pdim)[,pdim:1], main="true covariance")
image(mA[,pdim:1], main="AIRM")
image(mC[,pdim:1], main="Cholesky")
image(mE[,pdim:1], main="Euclidean")
image(mL[,pdim:1], main="LERM")
image(mPS[,pdim:1], main="Procrustes.SS")
image(mPF[,pdim:1], main="Procrustes.Full")
image(mPE[,pdim:1], main="PowerEuclidean")
image(mRE[,pdim:1], main="RootEuclidean")
par(opar)
}

}
\references{
\insertRef{dryden_non-euclidean_2009}{CovTools}
}
