% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renewal_methods.R
\name{chiSq_gof}
\alias{chiSq_gof}
\alias{chiSq_gof.renewal}
\alias{chiSq_gof.negbin}
\alias{chiSq_gof.glm}
\title{Formal Chi-square goodness-of-fit test}
\usage{
chiSq_gof(object, breaks, ...)

\method{chiSq_gof}{renewal}(object, breaks, ...)

\method{chiSq_gof}{negbin}(object, breaks, ...)

\method{chiSq_gof}{glm}(object, breaks, ...)
}
\arguments{
\item{object}{an object from class \code{renewal}.}

\item{breaks}{integer values at which the breaks shoudl happen. The function
will compute the observed frequencies in the intervals \code{[breaks[i],
breaks[i + 1])}.}

\item{...}{currently not used.}
}
\value{
data.frame
}
\description{
Carry out the formal chi-square goodness-of-fit test described by Cameron
(2013).
}
\details{
The test is a conditional moment test described in details in Cameron (2013,
Section 5.3.4). We compute the asymptotically equivalent outer product of the
gradient version which is justified for renewal models (fully parametric +
parameters based on MLE).
}
\references{
\insertRef{cameron2013regression}{Countr}
}
\seealso{
\code{\link{chiSq_pearson}}
}
