# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @keywords internal
sWeibull <- function(t, distPars) {
    .Call('_Countr_sWeibull', PACKAGE = 'Countr', t, distPars)
}

#' @keywords internal
sBurr <- function(t, distPars) {
    .Call('_Countr_sBurr', PACKAGE = 'Countr', t, distPars)
}

#' @keywords internal
sgamma <- function(t, distPars) {
    .Call('_Countr_sgamma', PACKAGE = 'Countr', t, distPars)
}

#' @keywords internal
sgengamma <- function(t, distPars) {
    .Call('_Countr_sgengamma', PACKAGE = 'Countr', t, distPars)
}

#' Wrapper to built in survival functions
#'
#' Wrapper to built in survival functions
#'
#' The function wraps all builtin-survival distributions. User can choose
#' between the \code{weibull}, \code{gamma}, \code{gengamma}(generalized gamma)
#' and \code{burr} (Burr type XII distribution). It is the user responsibility
#' to pass the appropriate list of parameters as follows:
#' \describe{
#' \item{weibull}{\code{scale} (the scale) and \code{shape} (the shape)
#'     parameters.}
#' \item{burr}{\code{scale} (the scale) and \code{shape1} (the shape1) and
#'     \code{shape2} (the shape2) parameters.} 
#' \item{gamma}{ \code{scale} (the scale) and \code{shape} (the shape)
#'     parameter.}
#' \item{gengamma}{\code{mu} (location), \code{sigma} (scale) and \code{Q}
#'     (shape) parameters.}
#' }
#' @param t double, time point where the survival is to be evaluated at.
#' @param distPars \code{Rcpp::List} with distribution specific slots,
#'     see details.
#' @param dist character name of the built-in distribution, see details.
#' @return a double giving the value of the survival function at time point
#' \code{t} at the parameters' values.
#'
#' @examples
#' tt <- 2.5
#' ## weibull
#'
#' distP <- list(scale = 1.2, shape = 1.16)
#' alpha <- exp(-log(distP[["scale"]]) / distP[["shape"]])
#' pweibull(q = tt, scale = alpha, shape = distP[["shape"]],
#'                       lower.tail = FALSE)
#' surv(tt, distP, "weibull") ## (almost) same
#'
#' ## gamma
#' distP <- list(shape = 0.5, rate = 1.0 / 0.7)
#' pgamma(q = tt, rate = distP[["rate"]], shape = distP[["shape"]],
#'                     lower.tail = FALSE)
#' surv(tt, distP, "gamma")  ## (almost) same
#'
#' ## generalized gamma
#' distP <- list(mu = 0.5, sigma = 0.7, Q = 0.7)
#' flexsurv::pgengamma(q = tt, mu = distP[["mu"]],
#'                     sigma = distP[["sigma"]],
#'                     Q = distP[["Q"]],
#'                     lower.tail = FALSE)
#' surv(tt, distP, "gengamma")  ## (almost) same
#'
#' @export
surv <- function(t, distPars, dist) {
    .Call('_Countr_surv', PACKAGE = 'Countr', t, distPars, dist)
}

#' Compute count probabilities using simple convolution
#'
#' Compute count probabilities using simple convolution (section 2) for the
#' built-in distributions
#'
#' The routine does convolutions to produce probabilities \code{probs(0)},
#' ... \code{probs(xmax)} using \code{nsteps} steps, and refines result by
#' Richardson extrapolation if \code{extrap} is \code{TRUE} using the
#' algorithm of section 2.
#'
#' @param x integer (vector), the desired count values.
#' @inheritParams surv
#' @param nsteps unsiged integer number of steps used to compute the integral.
#' @param time double time at wich to compute the probabilities. Set to 1 by
#' default.
#' @param extrap logical if \code{TRUE}, Richardson extrapolation will be
#' applied to improve accuracy.
#' @param logFlag logical if \code{TRUE} the log-probability will be returned.
#' @return vector of probabilities P(x(i)) for i = 1, ..., n where n is
#' \code{length} of \code{x}.
#'
#' @keywords internal
dCount_allProbs_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_allProbs_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' Compute count probabilities using simple convolution
#'
#' Compute count probabilities using simple convolution (section 2) for user
#' passed survival functions
#'
#' @param extrapolPars ma::vec of length 2. The extrapolation values.
#' @param survR Rcpp::Function user passed survival function; should have the
#' signature \code{function(t, distPars)} where \code{t} is a real number (>0)
#' where the survival function is evaluated and \code{distPars} is a list of
#' distribution parameters. It should return a double value.
#' @inheritParams dCount_allProbs_bi
#' @rdname dCount_allProbs_bi
#' @keywords internal
dCount_allProbs_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_allProbs_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_allProbs_scalar_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_allProbs_scalar_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_allProbs_vec_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_allProbs_vec_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_allProbs_scalar_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_allProbs_scalar_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_allProbs_vec_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_allProbs_vec_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

#' Compute count probabilities using dePril convolution (bi)
#'
#' Compute count probabilities using dePril convolution (section 3.2) for the
#' built-in distributions
#'
#' The routine does minimum number of convolution using dePril trick
#' to compute the count
#' probability P(x) sing \code{nsteps} steps, and refines result by
#' Richardson extrapolation if \code{extrap} is \code{TRUE} using the
#' algorithm of section 3.2.
#'
#' @param inheritParams dCount_naive_bi
#' @return vector of probabilities P(x(i)) for i = 1, ..., n where n is
#' \code{length} of \code{x}.
#'
#' @keywords internal
dCount_dePril_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dCount_dePril_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, cdfout, logFlag)
}

#' Compute count probabilities using dePril convolution (user)
#'
#' Compute count probabilities using dePril convolution (section 3.2) for the
#' user passed survival function.
#'
#' @param survR Rcpp::Function user passed survival function; should have the
#' signature \code{function(t, distPars)} where \code{t} is a real number (>0)
#' where the survival function is evaluated and \code{distPars} is a list of
#' distribution parameters. It should return a double value.
#' @inheritParams dCount_dePril_bi
#' @rdname dCount_dePril_bi
#' @keywords internal
dCount_dePril_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dCount_dePril_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, cdfout, logFlag)
}

#' @keywords internal
dCount_dePril_scalar_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_dePril_scalar_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_dePril_vec_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_dePril_vec_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_dePril_scalar_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_dePril_scalar_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_dePril_vec_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_dePril_vec_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

#' Compute count probabilities using naive convolution (bi)
#'
#' Compute count probabilities using naive convolution (section 3.1) for the
#' built-in distributions
#'
#' The routine does minimum number of convolution to compute the count
#' probability P(x) sing \code{nsteps} steps, and refines result by
#' Richardson extrapolation if \code{extrap} is \code{TRUE} using the
#' algorithm of section 3.1.
#'
#' @param cdfout logical if \code{TRUE}, the cdf will be returned instead of
#' the count probability.
#' @param inheritParams dCount_allProbs_bi
#' @return vector of probabilities P(x(i)) for i = 1, ..., n where n is
#' \code{length} of \code{x}.
#'
#' @keywords internal
dCount_naive_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dCount_naive_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, cdfout, logFlag)
}

#' Compute count probabilities using naive convolution (user)
#'
#' Compute count probabilities using naive convolution (section 3.1) for the
#' user passed survival function.
#'
#' @param survR Rcpp::Function user passed survival function; should have the
#' signature \code{function(t, distPars)} where \code{t} is a real number (>0)
#' where the survival function is evaluated and \code{distPars} is a list of
#' distribution parameters. It should return a double value.
#' @inheritParams dCount_naive_bi
#' @rdname dCount_naive_bi
#' @keywords internal
dCount_naive_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dCount_naive_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, cdfout, logFlag)
}

#' @keywords internal
dCount_naive_scalar_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_naive_scalar_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_naive_vec_bi <- function(x, distPars, dist, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_naive_vec_bi', PACKAGE = 'Countr', x, distPars, dist, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_naive_scalar_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_naive_scalar_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dCount_naive_vec_user <- function(x, distPars, extrapolPars, survR, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dCount_naive_vec_user', PACKAGE = 'Countr', x, distPars, extrapolPars, survR, nsteps, time, extrap, logFlag)
}

getProbsmodified_dePril <- function(xnum, distPars, dist, distPars0, dist0, extrapolPars, nsteps = 100L, time = 1.0, extrap = TRUE) {
    .Call('_Countr_getProbsmodified_dePril', PACKAGE = 'Countr', xnum, distPars, dist, distPars0, dist0, extrapolPars, nsteps, time, extrap)
}

#' Compute count probabilities based on modified renewal process (bi)
#'
#' Compute count probabilities based on modified renewal process using
#' dePril algorithm.
#' \code{dmodifiedCount_bi} does it for the builtin distributions.
#'
#' For the modified renewal process the first arrival is allowed to have
#' a different distribution from the  time between subsequent arrivals.
#' The renewal assumption is kept.
#'
#' @param x integer (vector), the desired count values.
#' @param distPars0,distPars \code{Rcpp::List} with distribution specific slots
#'     for the first arrival and the rest of the process respectively.
#' @param dist0,dist character, name of the first and following survival
#'     distributions.
#' @param cdfout TODO
#' @inheritParams dCount_allProbs_bi
#'
#' @return vector of probabilities P(x(i)) for i = 1, ..., n where n is
#'     the length of \code{x}.
#' @export
dmodifiedCount_bi <- function(x, distPars, dist, distPars0, dist0, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dmodifiedCount_bi', PACKAGE = 'Countr', x, distPars, dist, distPars0, dist0, nsteps, time, extrap, cdfout, logFlag)
}

#' % Compute count probabilities based on modified renewal process (user)
#'
#' % Compute count probabilities based on modified renewal process using
#' % dePril algorithm.
#' \code{dmodifiedCount_user} does the same for a user specified distribution.
#' 
#' @param survR0,survR user supplied survival function; should have 
#'     signature \code{function(t, distPars)}, where \code{t} is a positive real
#'     number (the time at which the survival function is evaluated) and
#'     \code{distPars} is a list of distribution parameters. It should return a
#'     double value (first arrival and following arrivals respectively).
#' @param extrapolPars list of same length as \code{x}, where each slot is a
#'     vector of length 2 (the extrapolation values to be used) corresponding to
#'     \code{x[i]}.
#' @inheritParams dmodifiedCount_bi
#'
#' @rdname dmodifiedCount_bi
dmodifiedCount_user <- function(x, distPars, survR, distPars0, survR0, extrapolPars, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dmodifiedCount_user', PACKAGE = 'Countr', x, distPars, survR, distPars0, survR0, extrapolPars, nsteps, time, extrap, cdfout, logFlag)
}

#' @keywords internal
dmodifiedCount_scalar_bi <- function(x, distPars, dist, distPars0, dist0, nsteps = 100L, time = 1.0, extrap = TRUE, logFlag = FALSE) {
    .Call('_Countr_dmodifiedCount_scalar_bi', PACKAGE = 'Countr', x, distPars, dist, distPars0, dist0, nsteps, time, extrap, logFlag)
}

#' @keywords internal
dmodifiedCount_scalar_user <- function(x, distPars, survR, distPars0, survR0, extrapolPars, nsteps = 100L, time = 1.0, extrap = TRUE, cdfout = FALSE, logFlag = FALSE) {
    .Call('_Countr_dmodifiedCount_scalar_user', PACKAGE = 'Countr', x, distPars, survR, distPars0, survR0, extrapolPars, nsteps, time, extrap, cdfout, logFlag)
}

#' Univariate Weibull Count Probability with gamma heterogeneity
#'
#' @param r,alpha double gamma parameters
#' @keywords internal
dWeibullgammaCount_mat <- function(x, shape, r, alpha, time = 1.0, logFlag = FALSE, jmax = 100L) {
    .Call('_Countr_dWeibullgammaCount_mat', PACKAGE = 'Countr', x, shape, r, alpha, time, logFlag, jmax)
}

#' @keywords internal
dWeibullgammaCount_mat_vec <- function(x, shape, r, alpha, time = 1.0, logFlag = FALSE, jmax = 100L) {
    .Call('_Countr_dWeibullgammaCount_mat_vec', PACKAGE = 'Countr', x, shape, r, alpha, time, logFlag, jmax)
}

#' Univariate Weibull Count Probability with gamma and
#' covariate heterogeneity
#'
#' @param r numeric shape of the gamma distribution
#' @param alpha numeric rate of the gamma distribution
#' @param Xcovar matrix covariates value
#' @param beta numeric vector of slopes
#' @param x,cc,t,logFlag,jmax TODO
#' keywords internal
dWeibullgammaCount_mat_Covariates <- function(x, cc, r, alpha, Xcovar, beta, t = 1.0, logFlag = FALSE, jmax = 100L) {
    .Call('_Countr_dWeibullgammaCount_mat_Covariates', PACKAGE = 'Countr', x, cc, r, alpha, Xcovar, beta, t, logFlag, jmax)
}

#' @keywords internal
dWeibullgammaCount_mat_Covariates_vec <- function(x, cc, r, alpha, Xcovar, beta, t = 1.0, logFlag = FALSE, jmax = 100L) {
    .Call('_Countr_dWeibullgammaCount_mat_Covariates_vec', PACKAGE = 'Countr', x, cc, r, alpha, Xcovar, beta, t, logFlag, jmax)
}

#' Fast Univariate Weibull Count Probability with gamma heterogeneity
#'
#' @param x integer (vector), the desired count values.
#' @param shape numeric, shape parameter.
#' @param time double, length of the observation window (defaults to 1).
#' @param r numeric shape of the gamma distribution
#' @param alpha numeric rate of the gamma distribution
#' @param printa logical, if \code{TRUE} print information about convergence.
#' @param logFlag logical, if TRUE, the log of the probability will be returned.
#' @param jmax integer, number of terms used to approximate the (infinite)
#'     series.
#' @param nmax integer, an upper bound on the number of terms to be summed in
#'     the Euler-van Wijngaarden sum; default is 300 terms.
#' @param eps numeric, the desired accuracy to declare convergence.
#' @rdname dWeibullgammaCount
#' @keywords internal
dWeibullgammaCount_acc <- function(x, shape, r, alpha, time = 1.0, logFlag = FALSE, jmax = 100L, nmax = 300L, eps = 1e-10, printa = FALSE) {
    .Call('_Countr_dWeibullgammaCount_acc', PACKAGE = 'Countr', x, shape, r, alpha, time, logFlag, jmax, nmax, eps, printa)
}

#' @keywords internal
dWeibullgammaCount_acc_vec <- function(x, shape, r, alpha, time = 1.0, logFlag = FALSE, jmax = 100L, nmax = 300L, eps = 1e-10, printa = FALSE) {
    .Call('_Countr_dWeibullgammaCount_acc_vec', PACKAGE = 'Countr', x, shape, r, alpha, time, logFlag, jmax, nmax, eps, printa)
}

#' @keywords internal
dWeibullgammaCount_acc_Covariates <- function(x, cc, r, alpha, Xcovar, beta, t = 1.0, logFlag = FALSE, jmax = 100L, nmax = 300L, eps = 1e-10, printa = FALSE) {
    .Call('_Countr_dWeibullgammaCount_acc_Covariates', PACKAGE = 'Countr', x, cc, r, alpha, Xcovar, beta, t, logFlag, jmax, nmax, eps, printa)
}

#' @keywords internal
dWeibullgammaCount_acc_Covariates_vec <- function(x, cc, r, alpha, Xcovar, beta, t = 1.0, logFlag = FALSE, jmax = 100L, nmax = 300L, eps = 1e-10, printa = FALSE) {
    .Call('_Countr_dWeibullgammaCount_acc_Covariates_vec', PACKAGE = 'Countr', x, cc, r, alpha, Xcovar, beta, t, logFlag, jmax, nmax, eps, printa)
}

#' Matrix of alpha terms
#'
#' Matrix of alpha terms used internally by the different Weibull count
#' functions.
#'
#' It is usually advisable to compute the alpha terms a minimum number of times
#' as it may be time consuming in general. Note that the alpha terms only depend
#' on the shape (c) parameter
#'
#' @param cc numeric, shape parameter.
#' @param jrow numeric, number of rows of the alpha matrix. See formulae (11) in
#'     \emph{McShane(2008)}.
#' @param ncol numeric, number of columns of the alpha matrix. Note that the
#'     first column corresponds to \eqn{n=0}, \eqn{n} being the count value, see
#'     formulae (11) in \emph{McShane(2008)}.
#' @return \code{jrow} x \code{ncol} (lower triangular) matrix of
#'     \eqn{\alpha_j^n} terms defined in \emph{McShane(2008)}.
#' @examples
#' ## alphagen(0.994, 6, 8)
#'
#' @keywords internal
alphagen <- function(cc, jrow, ncol) {
    .Call('_Countr_alphagen', PACKAGE = 'Countr', cc, jrow, ncol)
}

#' Univariate Weibull Count Probability
#'
#' Univariate Weibull count probability computed using matrix techniques.
#'
#' \code{dWeibullCount_mat} implements formulae (11) of \emph{McShane(2008)} to
#' compute the required probabilities.  For speed, the computations are
#' implemented in C++ and of matrix computations are used whenever possible.
#' This implementation is not efficient as it recomputes the alpha
#' matrix each time, which may slow down computation (among other things).
#'
#' \code{dWeibullCount_acc} achieves a vast (several orders of magnitude) speed
#' improvement over \code{pWeibullCountOrig}. We achieve this by using Euler-van
#' Wijngaarden techniques for accelerating the convergence of alternating series
#' and tabulation of the alpha terms available in a pre-computed matrix (shipped
#' with the package).
#'
#' When computation time is an issue, we recommend the use of
#' \code{dWeibullCount_fast}. However, \code{pWeibullCountOrig} may be more
#' accurate, especially when \code{jmax} is large.
#'
#' @param scale numeric (length 1), scale parameter of the Weibull count.
#' @param shape numeric (length 1), shape parameter of the Weibull count.
#' @param x integer (vector), the desired count values.
#' @param time double, length of the observation window (defaults to 1).
#' @param logFlag logical, if TRUE, the log of the probability will be returned.
#' @param jmax integer, number of terms used to approximate the (infinite)
#'     series.
#' @return a vector of probabilities for each component of the count vector
#'     \code{x}.
#'
#' @keywords internal
dWeibullCount_mat <- function(x, shape, scale, time = 1.0, logFlag = FALSE, jmax = 50L) {
    .Call('_Countr_dWeibullCount_mat', PACKAGE = 'Countr', x, shape, scale, time, logFlag, jmax)
}

#' @keywords internal
dWeibullCount_mat_scalar <- function(x, shape, scale, time = 1.0, logFlag = FALSE, jmax = 50L) {
    .Call('_Countr_dWeibullCount_mat_scalar', PACKAGE = 'Countr', x, shape, scale, time, logFlag, jmax)
}

#' @keywords internal
dWeibullCount_mat_vec <- function(x, shape, scale, time = 1.0, logFlag = FALSE, jmax = 50L) {
    .Call('_Countr_dWeibullCount_mat_vec', PACKAGE = 'Countr', x, shape, scale, time, logFlag, jmax)
}

#' Fast Univariate Weibull Count Probability
#'
#' @param nmax integer, an upper bound on the number of terms to be summed in
#'     the Euler-van Wijngaarden sum; default is 300 terms.
#' @param eps numeric, the desired accuracy to declare convergence.
#' @param printa logical, if \code{TRUE} print information about convergence.
#' @rdname dWeibullCount_mat
#'
#' @keywords internal
dWeibullCount_acc <- function(x, shape, scale, time = 1.0, logFlag = FALSE, jmax = 50L, nmax = 300L, eps = 1e-10, printa = FALSE) {
    .Call('_Countr_dWeibullCount_acc', PACKAGE = 'Countr', x, shape, scale, time, logFlag, jmax, nmax, eps, printa)
}

#' @keywords internal
dWeibullCount_acc_vec <- function(x, shape, scale, time = 1.0, logFlag = FALSE, jmax = 50L, nmax = 300L, eps = 1e-10, printa = FALSE) {
    .Call('_Countr_dWeibullCount_acc_vec', PACKAGE = 'Countr', x, shape, scale, time, logFlag, jmax, nmax, eps, printa)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_Countr_RcppExport_registerCCallable', PACKAGE = 'Countr')
})
