% Generated by roxygen2 (4.0.1): do not edit by hand
\name{CosmoPhotoZestimator}
\alias{CosmoPhotoZestimator}
\title{Photometric redshift  estimation from a training dataset and a test dataset}
\usage{
CosmoPhotoZestimator(trainData, testData, numberOfPcs, method, family, robust)
}
\arguments{
\item{trainData}{vector containing spectroscopic redshift data and photometry (at least one column shall be called redshift)}

\item{testData}{vector containing spectroscopic redshift data and photometry (at least one column shall be called redshift)}

\item{numberOfPcs}{an integer indicating the number of principal components to consider}

\item{method}{a string containing the chosen GLM method. Two options are available: \code{Frequentist} will use the function  \code{\link{glm}} from the package \code{stats}; \code{Bayesian} will use the function \code{\link{bayesglm}} from the package \code{arm}}

\item{family}{a string containing \code{gamma} or \code{inverse.gaussian} (a description of the error distribution and link function to be used in the model)}

\item{robust}{a boolean indicating if robust PCA should be used or not}
}
\value{
a vector with the estimated photometric redshifts
}
\description{
\code{CosmoPhotoZestimator} returns photometric redshift estimated from photometric
data and a training dataset with photometry and spectroscopy. The estimation is
based on generalized linear models (see \code{\link{glmTrainPhotoZ}} and \code{\link{glmPredictPhotoZ}}).
}
\examples{
\dontrun{
# Load the data
data(PHAT0train)
data(PHAT0test)

# Run the analysis
photoZest <- CosmoPhotoZestimator(PHAT0train, PHAT0test, 6)

# Create a boxplot showing the results
plotDiagPhotoZ(photoz = photoZest, specz = PHAT0test$redshift, type = "box")
}
}
\author{
Alberto Krone-Martins, Rafael S. de Souza
}
\keyword{utilities}

