% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ran.CMData}
\alias{ran.CMData}
\title{Generate a random CMData object}
\usage{
ran.CMData(n, ncat, clustersize.gen, distribution)
}
\arguments{
\item{n}{number of independent clusters to generate}

\item{ncat}{number of response categories}

\item{clustersize.gen}{either an integer vector specifying the sizes of the clusters,
which will be recycled to achieve the target number of clusters \code{n}; or
a function with one parameter that returns an integer vector of cluster sizes when
the target number of clusters n is passed to it as a parameter}

\item{distribution}{a list with two components: "multinom.gen" and "param" that specifies
the generation process for each cluster. The "multinom.gen" component should be a function
of three parameters: number of clusters, vector of cluster sizes, and parameter list, that
a matrix of response counts where each row is a cluster and each column is the number of
responses of a given type. The "param" component should specify the list of parameters
needed by the multinom.gen function.}
}
\value{
a \code{CMData} object with randomly generated number of responses with
sample sizes specified in the call
}
\description{
Generates random exchangeably correlated multinomial data based on a parametric
distribution or using resampling. The Dirichlet-Multinomial, Logistic-Normal mutlinomial,
and discrete mixture multinomial parametric distributions are implemented.
All observations will be assigned to the same treatment group, and there is no
guarantee of a specific order of the observations in the output.
}
\examples{
# Resample from the dehp dataset
data(dehp)
ran.dehp <- ran.CMData(20, 3, 10, list(multinom.gen=mg.Resample, param=list(data=dehp)))

# Dirichlet-Multinomial distribution with two treatment groups and random cluster sizes
binom.cs <- function(n){rbinom(n, p=0.3, size=10)+1}
dm1 <- ran.CMData(15, 4, binom.cs,
                  list(multinom.gen=mg.DirMult, param=list(shape=c(2,3,2,1))))
dm2 <- ran.CMData(15, 4, binom.cs,
                  list(multinom.gen=mg.DirMult, param=list(shape=c(1,1,4,1))))
ran.dm <- rbind(dm1, dm2)

# Logit-Normal multinomial distribution
ran.ln <- ran.CMData(13, 3, 3,
                     list(multinom.gen=mg.LogitNorm,
                          param=list(mu=c(-1, 1), sigma=matrix(c(1,0.8,0.8,2), nr=2))))

# Mixture of two multinomial distributions
unif.cs <- function(n){sample(5:9, size=n, replace=TRUE)}
ran.mm <- ran.CMData(6, 3, unif.cs,
                     list(multinom.gen=mg.MixMult,
                          param=list(q=c(0.8,0.2), m=rbind(c(-1,0), c(0,2)))))
}
\author{
Aniko Szabo
}
\seealso{
\code{\link{CMData}} for details about \code{CMData} objects; \code{\link{multinom.gen}} for built-in generating functions
}
\keyword{distribution}

