% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorShrinkData.R
\name{CorShrinkData}
\alias{CorShrinkData}
\title{Adaptive shrinkage of correlations from a data matrix}
\usage{
CorShrinkData(data, sd_boot = FALSE, type = "cor", cor_method,
  thresh_up = 0.99, thresh_down = -0.99, image = c("both", "original",
  "corshrink", "output", "null"), tol = 1e-06, nboot = 50,
  image.control = list(), report_model = FALSE, ash.control = list())
}
\arguments{
\item{data}{The samples by features data matrix. May contain NA values.}

\item{sd_boot}{A Boolean variable indicating if the standard errors of the
Fisher z-scores should be computed via Bootstrap methods or
through asymptotic formulation of the problem.}

\item{type}{character. Either "cor" or "pcor" - depending on whether to use
correlation or partial correlation. Default is "cor".}

\item{cor_method}{The method of correlation used. May be "pearson", "spearman" or "kendall"
depending on the type of correlation to be used by the user.}

\item{thresh_up}{Upper threshold for correlations. Defaults to 0.99}

\item{thresh_down}{Lower threshold for correlations. Defaults to -0.99.}

\item{image}{character. options for plotting the original or the corshrink matrix.
If \code{image = "both"}, then the function outputs both the plot
for original and shrunk correlationmatrix. If \code{image = "original"},
then the function outputs the correlation plot for the original matrix only.
If \code{image = "corshrink"}, then the function outputs the correlation plot
for the CorShrink matrix only.If \code{image = "output"}, then the function
outputs the saved ggplot figure without displaying it. If \code{image = "null"},
no image is output.Defaults to "both".}

\item{tol}{The tolerance chosen to check how far apart the CorShrink matrix is from the nearest
positive definite matrix before applying PD completion.}

\item{nboot}{The number of bootstrap samples if \code{sd_boot = TRUE}.}

\item{image.control}{Control parameters for the image when \code{image = TRUE}.}

\item{report_model}{if TRUE, outputs the full adaptive shrinkage output, else outputs the shrunken vector.
Defaults to FALSE.}

\item{ash.control}{The control parameters for adaptive shrinkage}
}
\value{
Returns an adaptively shrunk version of the sample correlations matrix.
}
\description{
Performs adaptive shrinkage of the sample correlations starting
from a data matrix (possibly containing NAs).
}
\examples{
data("sample_by_feature_data")
out <- CorShrinkData(sample_by_feature_data, image = "both")

}
\references{
False Discovery Rates: A New Deal. Matthew Stephens bioRxiv 038216; doi: http://dx.doi.org/10.1101/038216
}
\keyword{adaptive}
\keyword{correlation}
\keyword{shrinkage,}
