% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wms.r
\name{copernicus_wms2geotiff}
\alias{copernicus_wms2geotiff}
\title{Extract and store WMS as a geo-referenced TIFF}
\usage{
copernicus_wms2geotiff(
  product,
  layer,
  variable,
  region,
  destination,
  width,
  height
)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{copernicus_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{copernicus_product_details}}.}

\item{region}{Specification of the bounding box as a \code{vector} of \code{numeric}s WGS84 lat and lon coordinates.
Should be in the order of: xmin, ymin, xmax, ymax.}

\item{destination}{File name for the geo-referenced TIFF.}

\item{width}{Width in pixels of the TIFF image.}

\item{height}{Height in pixels of the TIFF image.}
}
\value{
Stores the file as \code{destination} and returns invisible \code{NULL}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function interacts with deprecated Copernicus Marine
Services. It will become \code{\link[=.Defunct]{.Defunct()}} in future versions. Extract and store imagery from a
Copernicus WMS as a geo-referenced TIFF.
}
\details{
A Web Map Service (WMS) cannot be plotted directly (base, ggplot2 and/or lattice).
For that purpose you need to extract and download a specific region in a format
that can be handled by plots. You can use this function to store a subset of a
WMS map as a geo-referenced TIFF file.
}
\note{
WMS functions don't work on systems that don't support GDAL utils
}
\examples{
\dontrun{
destination <- tempfile("wms", fileext = ".tiff")
copernicus_wms2geotiff(
  product     = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
  layer       = "cmems_mod_glo_phy-thetao_anfc_0.083deg_P1D-m",
  variable    = "thetao",
  region      = c(-1, 50, 7, 60),
  destination = destination,
  width       = 1920,
  height      = 1080
)
}
}
\seealso{
Other wms-functions: 
\code{\link{addCopernicusWMSTiles}()},
\code{\link{copernicus_wms_details}()}
}
\author{
Pepijn de Vries
}
\concept{wms-functions}
