% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_rv.R
\name{cal_rv}
\alias{cal_rv}
\title{Calculate Robustness Value When Executing Worstcase Calibration}
\usage{
cal_rv(
  y,
  tr,
  t1,
  t2,
  mu_y_dt = NULL,
  sigma_y_t = NULL,
  mu_u_dt = NULL,
  cov_u_t = NULL,
  nU = NULL,
  ...
)
}
\arguments{
\item{y}{\code{data.frame}, \code{matrix} or \code{vector}. Gaussian outcome variable.}

\item{tr}{\code{data.frame}. Treatment variables with rows corresponding to observations and columns
to variables.}

\item{t1}{\code{data.frame}. First treatment arms of interest.
May contain a single or multiple treatments in rows.}

\item{t2}{\code{data.frame}. Second treatment arms of interest,
which has same number of row as \code{t1}.}

\item{mu_y_dt}{an optional scalar or vector that contains naive estimates of treatment effects
ignoring confounding.}

\item{sigma_y_t}{an optional scalar of the standard deviation of outcome conditional on treatments.}

\item{mu_u_dt}{an optional matrix of difference in conditional confounder means, \eqn{E(U \mid t1) - E(U \mid t2)},
with latent variables in columns.}

\item{cov_u_t}{an optional covariance matrix of confounders conditional on treatments.}

\item{nU}{Number of latent confounders to consider.}

\item{...}{further arguments passed to \code{\link{kEstimate}}, \code{\link{pca}}}
}
\value{
A \code{numeric vector} with elements being the robustness value or \code{NA} if the ignorance region doesn't
contains 0 for each contrast of interest.
}
\description{
Calculate Robustness Value When Executing Worstcase Calibration
}
\examples{
\donttest{
# load the example data #
y <- GaussianT_GaussianY$y
tr <- subset(GaussianT_GaussianY, select = -c(y))
# calculate robustness value #
cal_rv(y = y, tr = tr, t1 = tr[1:2,], t2 = tr[3:4,])
}
}
