% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatelyConcept.R
\name{drawGatelyValue}
\alias{drawGatelyValue}
\title{draw Gately point for 3 or 4 players}
\usage{
drawGatelyValue(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Gately Value")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawGatelyValue draws the Gately point for 3 or 4 players.
}
\examples{
library(CoopGame)
drawGatelyValue(c(0,0,0,1,1,1,3.5))

\donttest{
#Example from original paper by Gately (1974):
library(CoopGame)
v=c(0,0,0,1170,770,210,1530)
drawGatelyValue(v)
}
}
\references{
Gately D. (1974) "Sharing the Gains from Regional Cooperation. A Game Theoretic Application to Planning Investment in Electric Power", International Economic Review 15(1), pp. 195--208

Staudacher J. and Anwander J. (2019) "Conditions for the uniqueness of the Gately point for cooperative games", arXiv preprint, arXiv:1901.01485, 10 pages.

Littlechild S.C. and Vaidya K.G. (1976) "The propensity to disrupt and the disruption nucleolus of a characteristic function game", Int. Journal of Game Theory 5(2), pp. 151--161

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, pp. 455--456
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
