% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_over_grid_with_batch.R
\name{eval_over_grid_with_batch}
\alias{eval_over_grid_with_batch}
\title{Evaluate function over grid of points}
\usage{
eval_over_grid_with_batch(x, y, fn, batchmax)
}
\arguments{
\item{x}{Vector of x values to evaluate}

\item{y}{Vector of y values to evaluate}

\item{fn}{Function that takes in a length two vector if `batchmax` is 1
or a matrix with two columns if greater than 1.}

\item{batchmax}{Number of points that can evaluated simultaneously.
If 1, points are passed to `fn` as a vector of length two.
If greater than 1, points are passed to `fn` as rows of a matrix.}
}
\value{
Matrix of size `length(x)` by `length(y)`
}
\description{
`batchmax` gives how many can be evaluated at a time.
If more than 1, then the input is given to the function
as rows of a matrix.
}
\examples{
eval_over_grid_with_batch(c(0,.5,1), c(10,20,30), function(a)a[1]+a[2], batchmax=1)
eval_over_grid_with_batch(c(0,.5,1), c(10,20,30), function(a)a[,1]+a[,2], batchmax=Inf)
}
