% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsensusOPLS-package.R
\docType{package}
\name{ConsensusOPLS-package}
\alias{ConsensusOPLS-package}
\alias{_PACKAGE}
\title{Consensus OPLS for Multi-Block Data Fusion}
\description{
Merging data from multiple sources is a relevant approach for 
comprehensively evaluating complex systems. However, the inherent problems 
encountered when analyzing single tables are amplified with the generation 
of multi-block datasets, and finding the relationships between data layers 
of increasing complexity constitutes a challenging task. For that purpose, 
a generic methodology is proposed by combining the strengths of established 
data analysis strategies, i.e. multi-block approaches and the OPLS framework
to provide an efficient tool for the fusion of data obtained from multiple 
sources. The package enables quick and efficient implementation of the 
consensus OPLS model for any horizontal multi-block data structure 
(observation-based matching). Moreover, it offers an interesting range of 
metrics and graphics to help to determine the optimal number of components 
and check the validity of the model through permutation tests. 
Interpretation tools include scores and loadings plots, as well as 
Variable Importance in Projection (VIP), and performance coefficients such 
as R2, Q2 and DQ2 coefficients.

This package uses functions from the K-OPLS package, developed by Max
Bylesjo, University of Umea, Judy Fonville and Mattias Rantalainen, Imperial
College.

Copyright (c) 2007-2010 Max Bylesjo, Judy Fonville and Mattias Rantalainen

This code has been extended and adapted under the terms of the GNU General
Public License version 2 as published by the Free Software Foundation.
}
\author{
\strong{Maintainer}: Van Du T. Tran \email{thuong.tran@sib.swiss} (\href{https://orcid.org/0000-0003-2074-5029}{ORCID})

Authors:
\itemize{
  \item Celine Bougel \email{celine.bougel@laposte.net} (\href{https://orcid.org/0000-0002-1598-7827}{ORCID})
  \item Julien Boccard \email{julien.boccard@unige.ch} (\href{https://orcid.org/0000-0001-5913-9566}{ORCID})
  \item Florence Mehl \email{florence.mehl@sib.swiss} (\href{https://orcid.org/0000-0002-9619-1707}{ORCID})
}

Other contributors:
\itemize{
  \item Marie Tremblay-Franco \email{marie.tremblay-franco@inrae.fr} (\href{https://orcid.org/0000-0003-4678-4456}{ORCID}) [funder]
  \item Mark Ibberson \email{mark.ibberson@sib.swiss} (\href{https://orcid.org/0000-0003-3152-5670}{ORCID}) [funder]
}

}
