% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelEstimation.R
\name{estimateCondCDF_matrix}
\alias{estimateCondCDF_matrix}
\title{Compute kernel-based conditional marginal (univariate) cdfs}
\usage{
estimateCondCDF_matrix(observedX1, newX1, matrixK3)
}
\arguments{
\item{observedX1}{a sample of observations of X1 of size \code{n}}

\item{newX1}{a sample of new points for the variable X1, of size \code{p1}}

\item{matrixK3}{a matrix of kernel values of dimension \code{(p3, n)}
\eqn{\big(K_h(X3[i] - U3[j])\big)_{i,j}}
such as given by \code{\link{computeKernelMatrix}}.}
}
\value{
A matrix of dimensions \code{(p1 = length(newX), p3 = length(matrixK3[,1]))}
of estimators \eqn{\hat P(X_1 \leq x_1 | X_3 = x_3)} for every possible choices
of \eqn{(x_1, x_3)}.
}
\description{
This function computes an estimate of the conditional (marginal) cdf
of X1 given a conditioning variable X3.
}
\details{
This function is supposed to be used with \code{\link{computeKernelMatrix}}.
Assume that we observe a sample \eqn{(X_{i,1}, X_{i,3}), i=1, \dots, n}.
We want to estimate the conditional cdf of \eqn{X_1} given \eqn{X_3 = x_3}
at point \eqn{x_1} using the following kernel-based estimator
\deqn{\hat P(X_1 \le x_1 | X_3 = x_3)
:= \frac{\sum_{l=1}^n 1 \{X_{l,1} \leq x_1 \} K_h(X_{l,3} - x_3)}
{\sum_{l=1}^n K_h(X_{l,3} - x_3)},}
for every \eqn{x_1} in \code{newX1} and every \eqn{x_3} in \code{newX3}.
The \code{matrixK3} should be a matrix of the values \eqn{K_h(X_{l,3} - x_3)}
such as the one produced by
\code{\link{computeKernelMatrix}(observedX3, newX3, kernel, h)}.
}
\examples{
Y = MASS::mvrnorm(n = 100, mu = c(0,0), Sigma = cbind(c(1, 0.9), c(0.9, 1)))
newY1 = seq(-1, 1, by = 0.5)
newY2 = c(0, 1, 2)
matrixK = computeKernelMatrix(observedX = Y[,2], newX = newY2,
  kernel = "Gaussian", h = 0.8)
# In this matrix, there are the estimated conditionl cdf at points given by newY1
# conditionally to the points given by newY2.
matrixCondCDF = estimateCondCDF_matrix(observedX1 = Y[,1],
  newX1 = newY1, matrixK)
matrixCondCDF

}
