% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelEstimation.R
\name{computeKernelMatrix}
\alias{computeKernelMatrix}
\title{Computing the kernel matrix}
\usage{
computeKernelMatrix(observedX, newX, kernel, h)
}
\arguments{
\item{observedX}{a numeric vector of observations of X3.
on the interval \eqn{[0,1]}.}

\item{newX}{a numeric vector of points of X3.}

\item{kernel}{a character string describing the kernel to be used.
Possible choices are \code{Gaussian}, \code{Triangular} and \code{Epanechnikov}.}

\item{h}{the bandwidth}
}
\value{
a numeric matrix of dimensions \code{(length(observedX), length(newX))}
}
\description{
This function computes a matrix of dimensions \code{(length(observedX3), length(newX3))},
whose element at coordinate \code{(i,j)} is
\eqn{ K_{h}(}\code{observedX3}\eqn{[i] - }\code{newX3}\eqn{[j] )},
where \eqn{K_h(x) := K(x/h) / h} and \eqn{K} is the \code{kernel}.
}
\examples{
Y = MASS::mvrnorm(n = 100, mu = c(0,0), Sigma = cbind(c(1, 0.9), c(0.9, 1)))
matrixK = computeKernelMatrix(observedX = Y[,2], newX = c(0, 1, 2.5),
kernel = "Gaussian", h = 0.8)

# To have an estimator of the conditional expectation of Y1 given Y2 = 0, 1, 2.5
Y[,1] * matrixK[,1] / sum(matrixK[,1])
Y[,1] * matrixK[,2] / sum(matrixK[,2])
Y[,1] * matrixK[,3] / sum(matrixK[,3])

}
\seealso{
\code{\link{estimateCondCDF_matrix}}, \code{\link{estimateCondCDF_vec}},
}
