% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLM.R
\name{calcLM}
\alias{calcLM}
\title{Life-time multiplier for chemical degradation}
\usage{
calcLM(Temp, RH, EA = 100)
}
\arguments{
\item{Temp}{Temperature (Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{EA}{Activation Energy (J/mol).
100 J/mol for cellulosic (paper) or 70 J/mol yellowing varnish}
}
\value{
Lifetime multiplier
}
\description{
Function to calculate lifetime multiplier from temperature and relative humidity.

The lifetime multiplier calculates the expected lifetime of an object for a given point
relative to to the lifetime at 20°C and 50\%RH.
This can used to then average over the length of the dataset.

The lifetime multiplier gives an indication of the speed of natural decay of an object.
It expresses an expected lifetime of an object compared to the expected lifetime of
the same object at 20°C and 50\% RH. This means that if the result = 1, the expected
lifetime for your object is 'good'. The closer you go to 0, the less suited your environment is.
The result is both expressed numerically and over time, which also gives an idea
about the period over the year when the object suffers most.
The data is based on experiments on paper, synthetic films and dyes.
}
\details{
Based on the experiments of the rate of decay of paper, films and dyes.
Activation energy, Ea = 100 J/mol (degradation of cellulose - paper),
70 J/mol (yellowing of varnish - furniture, painting, sculpture).

Gas constant, R = 8.314 J/K.mol

\deqn{LM=\left(\frac{50\%RH}{RH}\right)^{1.3}.e\left(\frac{E_a}{R}.\left(\frac{1}{T_K}-\frac{1}{293}\right)\right)}
}
\examples{
calcLM(20, 50)

calcLM(20, 50, EA = 70)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(LifeTime = calcLM(Temp, RH))

mydata |>
  dplyr::mutate(LM = calcLM(Temp, RH)) |>
   dplyr::summarise(LM_avg = mean(LM, na.rm = TRUE))


}
\references{
Michalski, S., ‘Double the life for each five-degree drop,
more than double the life for each halving of relative humidity’,
in Preprints of the 13th IcOM-cc Triennial Meeting in rio de Janeiro (22–27 September 2002),
ed. r. Vontobel, James & James, London (2002) Vol. I 66–72.

Martens Marco, 2012: Climate Risk Assessment in Museums (Thesis, Tue).
}
