% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compCL.R
\name{compCL}
\alias{compCL}
\title{Fit regularization path for log-contrast model of compositional data with lasso penalty.}
\usage{
compCL(y, Z, Zc = NULL, intercept = TRUE,
       lam = NULL, nlam = 100, lambda.factor = ifelse(n < p, 0.05, 0.001),
       pf = rep(1, times = p), dfmax = p, pfmax = min(dfmax * 1.5, p),
       u = 1, mu_ratio = 1.01, tol = 1e-10,
       inner_maxiter = 1e+4, inner_eps = 1e-6,
       outer_maxiter = 1e+08, outer_eps = 1e-8)
}
\arguments{
\item{y}{a response vector with length n.}

\item{Z}{a \eqn{n \times p}{n*p} design matrix of compositional data or categorical data.
If \code{Z} is categorical data, i.e., row-sums of \code{Z} differ from 1, the program automatically transforms
\code{Z} into compositional data by dividing each row by its sum.
\code{Z} could NOT include entry of 0's.}

\item{Zc}{a \eqn{n*p_c} design matrix of control variables (not penalized). Default is \code{NULL}.}

\item{intercept}{Boolean, specifying whether to include an intercept.
Default is \code{FALSE}.}

\item{lam}{a user supplied lambda sequence.
If \code{lam} is provided as a scaler and \code{nlam}\eqn{>1}, \code{lam} sequence is created starting from
\code{lam}. To run a single value of \code{lam}, set \code{nlam}\eqn{=1}.
The program will sort user-defined \code{lambda} sequence in decreasing order.}

\item{nlam}{the length of the \code{lam} sequence. Default is 100. No effect if \code{lam} is
provided.}

\item{lambda.factor}{the factor for getting the minimal lambda in the \code{lam} sequence,
where \code{min(lam)} = \code{lambda.factor} * \code{max(lam)}.
\code{max(lam)} is the smallest value of \code{lam} for which all penalized coefficients become zero.
If \eqn{n >= p}, the default is \code{0.001}. If \eqn{n < p}, the default is \code{0.05}.}

\item{pf}{penalty factor, a vector of length p. Zero implies no shrinkage. Default value for each entry is 1.}

\item{dfmax}{limit the maximum number of groups in the model. Useful for handling very large \eqn{p}, if a partial path is desired.
Default is \eqn{p}.}

\item{pfmax}{limit the maximum number of groups ever to be nonzero. For example once a group enters the model along the path,
no matter how many times it re-enters the model through the path, it will be counted only once.
Default is \code{min(dfmax*1.5, p)}.}

\item{u}{the inital value of the penalty parameter of the augmented Lagrange method adopted in the outer loop. Default value is 1.}

\item{mu_ratio}{the increasing ratio, with value at least 1, for \code{u}. Default value is 1.01.
Inital values for scaled Lagrange multipliers are set as 0's.
If \code{mu_ratio} < 1, the program automatically set \code{u} as 0 and \code{outer_maxiter} as 1, indicating
that there is no linear constraints included.}

\item{tol}{tolerance for the estimated coefficients to be considered as non-zero, i.e., if \eqn{abs(\beta_j)} < \code{tol}, set \eqn{\beta_j} as 0.
Default value is 1e-10.}

\item{inner_maxiter, inner_eps}{\code{inner_maxiter} is the maximun number of loops allowed in the coordinate descent;
and \code{inner_eps} is the corresponding convergence tolerance.}

\item{outer_maxiter, outer_eps}{\code{outer_maxiter} is the maximum number of loops allowed in the Augmented Lagrange method;
and \code{outer_eps} is the corresponding convergence tolerance.}
}
\value{
An object with S3 calss \code{"compCL"} is a list containing:
\item{beta}{a matrix of coefficients for \eqn{p+p_c+1} rows.
            If \code{intercept=FALSE}, then the last row of \code{beta} is set to 0's.}
\item{lam}{the sequence of \code{lam} values used.}
\item{df}{the number of non-zero \eqn{\beta_p}'s in estimated coefficients for \code{Z} at each value of \code{lam}.}
\item{npass}{total iterations.}
\item{error}{error messages. If 0, no error occurs.}
\item{call}{the call that produces this object.}
\item{dim}{dimension of the coefficient matrix \code{beta}.}
}
\description{
Fit regression with compositional predictors via penalized \emph{log-contrast} model which was proposed by Lin et al. (2014) <doi:10.1093/biomet/asu031>.
The model estimation is conducted by minimizing a linearly constrained lasso criterion. The regularization paths are
computed at a grid of tuning parameter \code{lambda}.
}
\details{
The \emph{log-contrast} regression model with compositional predictors is expressed as
\deqn{y = Z\beta + e, s.t. \sum_{j=1}^{p}\beta_j=0,}
where \eqn{Z} is the n-by-p design matrix of log-transforemd compositional data,
\eqn{\beta} is the p-vector of regression cofficients,
and \eqn{e} is an n-vector of random errors.
If zero(s) exists in the original compositional data, user should pre-process these zero(s).
\cr
To enable variable selection, we conduct model estimation via linearly constrained lasso
\deqn{
argmin_{\beta}(\frac{1}{2n}\|y-Z\beta\|_2^2 + \lambda\|\beta\|_1), s.t. \sum_{j=1}^{p}\beta_j= 0.
}
}
\examples{
p = 30
n = 50
beta = c(1, -0.8, 0.6, 0, 0, -1.5, -0.5, 1.2)
beta = c(beta, rep(0, times = p - length(beta)))
Comp_data = comp_Model(n = n, p = p, beta = beta, intercept = FALSE)
m1 <- compCL(y = Comp_data$y, Z = Comp_data$X.comp,
             Zc = Comp_data$Zc, intercept = Comp_data$intercept)
print(m1)
plot(m1)
beta = coef(m1)
Test_data = comp_Model(n = 30, p = p, beta = Comp_data$beta, intercept = FALSE)
predmat = predict(m1, Znew = Test_data$X.comp, Zcnew = Test_data$Zc)

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979
}
\seealso{
\code{\link[=coef.compCL]{coef}}, \code{\link[=predict.compCL]{predict}},
\code{\link[=print.compCL]{print}} and \code{\link[=plot.compCL]{plot}} methods
for \code{"compCL"} object
and \code{\link{cv.compCL}} and \code{\link{GIC.compCL}}.
}
\author{
Zhe Sun and Kun Chen
}
