% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cophen.index.R
\name{cophen.index}
\alias{cophen.index}
\title{Computes the cophenetic balance index of a phylogenetic tree}
\usage{
cophen.index(tree, norm = FALSE)
}
\arguments{
\item{tree}{a single phylogenetic tree. It can be entered as a string the Newick format, as a 'phylo' object (\code{ape} package) or as an 'igraph' object (\code{igraph} package).}

\item{norm}{a logical variable that indicates whether the index should be normalized or not.}
}
\value{
A numeric value.
}
\description{
Given a phylogenetic tree, computes the cophenetic balance index of that phylogenetic tree.
}
\details{
The cophenetic index is computed as the sum of the depths of the least common ancestor (LCA) of every pair of leaves.
}
\examples{
# Computation of the cophenetic balance index of trees 
# entered in newick format:
cophen.index("(1,2,3,4,5);")
cophen.index("(1,(2,(3,(4,5))));")

# Computation of the cophenetic balance index of trees 
# entered as a phylo object:
require(ape)
random.tree = rtree(5,rooted=TRUE)
cophen.index(random.tree)

# Computation of the cophenetic balance index of a tree
# entered as a igraph object. The tree is randomly 
# generated from all trees with 5 leaves following
# the alpha-gamma model with alpha=0.5 and gamma=0.3.
a.g.tree = a.g.model(5,0.5,0.3)
cophen.index(a.g.tree)

#All of them can be normalized (values between 0 and 1)
cophen.index("(1,2,3,4,5);",norm=TRUE)
cophen.index("(1,(2,(3,(4,5))));",norm=TRUE)
cophen.index(random.tree,norm=TRUE)
cophen.index(a.g.tree,norm=TRUE)

}
\references{
A. Mir, F. Rossello, L.Rotger, A new balance index for phylogenetic trees. \emph{Mathematical Biosciences} \bold{241} (2013), 125-136.
}
\author{
Lucia Rotger
}
