% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortOverlap.R
\name{plotCohortOverlap}
\alias{plotCohortOverlap}
\title{Plot the result of summariseCohortOverlap.}
\usage{
plotCohortOverlap(
  result,
  uniqueCombinations = TRUE,
  y = NULL,
  facet = c("cdm_name", "cohort_name_reference"),
  colour = "variable_name",
  .options = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{y}{Variables to use in y axis, if NULL all variables not present in
facet are used.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{.options}{deprecated.}
}
\value{
A ggplot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

overlap <- summariseCohortOverlap(cdm$cohort2)

plotCohortOverlap(overlap, uniqueCombinations = FALSE)

mockDisconnect(cdm)
}

}
