% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseAchillesCodeUse.R
\name{summariseAchillesCodeUse}
\alias{summariseAchillesCodeUse}
\title{Summarise code use from achilles counts.}
\usage{
summariseAchillesCodeUse(x, cdm, countBy = c("record", "person"))
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts.}
}
\value{
A tibble with summarised counts.
}
\description{
Summarise code use from achilles counts.
}
\examples{
\donttest{
library(CodelistGenerator)
cdm <- mockVocabRef("database")
oa <- getCandidateCodes(cdm = cdm, keywords = "osteoarthritis")
codelist <- omopgenerics::newCodelist(list(oa = oa$concept_id))
result_achilles <- summariseAchillesCodeUse(codelist, cdm = cdm)
result_achilles
CDMConnector::cdmDisconnect(cdm)
}
}
