% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{calculate_result}
\alias{calculate_result}
\title{Method that returns the value or variable depending on where it is in the
calculated metrics.}
\usage{
calculate_result(
  algorith,
  distance,
  cluster,
  dataset,
  ranking,
  timeExternal,
  entropy,
  variation_information,
  precision,
  recall,
  fowlkes_mallows_index,
  f_measure,
  timeInternal,
  dunn,
  connectivity,
  silhouette,
  variables
)
}
\arguments{
\item{algorith}{Algorithm name.}

\item{distance}{Name of the metric used to calculate the distance between
points.}

\item{cluster}{Number of clusters.}

\item{dataset}{Name of dataset.}

\item{ranking}{Position we want to obtain from the list of variables.}

\item{timeExternal}{Array with the external validation calculation times of
the clustering.}

\item{entropy}{Array with the calculation of the entropy for each of the
variables.}

\item{variation_information}{Array with the calculation of the
variation_information for each of the variables.}

\item{precision}{Array with the calculation of the precision for each of the
variables.}

\item{recall}{Array with the calculation of the recall for each of the
variables.}

\item{fowlkes_mallows_index}{Array with the calculation of the
fowlkes_mallows_index for each of the variables.}

\item{f_measure}{Array with the calculation of the f_measure for each of the
variables.}

\item{timeInternal}{Array with the internal validation calculation times of
the clustering.}

\item{dunn}{Array with the calculation of the dunn for each of the variables.}

\item{connectivity}{Array with the calculation of the connectivity for each
of the variables.}

\item{silhouette}{Array with the calculation of the silhouette for each of
the variables.}

\item{variables}{True if we want to show the value of the metric calculation
and false if we want to show the variable.}
}
\value{
Returns an array with the calculation of each metric based on the
indicated position.
}
\description{
Method that returns the value or variable depending on where it is in the
calculated metrics.
}
\keyword{internal}
