% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{evaluate_best_validation_internal_by_metrics}
\alias{evaluate_best_validation_internal_by_metrics}
\title{Evaluates algorithms by measures of dissimilarity based on a metric.}
\usage{
evaluate_best_validation_internal_by_metrics(df, metric)
}
\arguments{
\item{df}{Data matrix or data frame with the result of running the clustering
algorithm.}

\item{metric}{It's a string with the metric to evaluate.}
}
\value{
A data.frame with the algorithms classified by measures of
dissimilarity.
}
\description{
Method that calculates which algorithm and which metric behaves
best for the datasets provided.
}
\details{
This method groups the data by algorithm and distance measure,
instead of obtaining the best attribute from the data set.
}
\examples{

result = clustering(
               df = cluster::agriculture,
               min = 4,
               max = 5,
               algorithm='gmm',
               metrics=c("Precision","Connectivity")
         )

evaluate_best_validation_internal_by_metrics(result,"Connectivity")

}
