% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.hclustgeo.R
\name{plot.hclustgeo}
\alias{plot.hclustgeo}
\title{Summary of a list of partition obtained with the method \code{hclustgeo}.}
\usage{
\method{plot}{hclustgeo}(x, choice = "maps", choice.alpha = NULL,
  K.range = c(3:5), path.shp = NULL, name.ind.shp = NULL,
  save.pdf = FALSE, path.pdf = NULL, ...)
}
\arguments{
\item{x}{an object of class 'hclustgeo' obtained with \code{hclustgeo}.}

\item{choice}{one of the following character strings: \code{'dendro'}
if the user wishes to plot the dendrogram; \code{'maps'} if the user
wants to plot the partitions (in K.range clusters) on a map;
\code{'quality'} if the user wants to plot the qualities of partitions
in order to choose a value for the parameter alpha.}

\item{choice.alpha}{a vector containig the values of parameter
of alpha the user wants to plot. If \code{NULL} all the values computed in \code{hclustgeo} are used.}

\item{K.range}{a vector containing several values of K for which the
user wishes to display plots in K clusters. If \code{NULL}, the value
of \code{K.range} is \code{c(3,4,5)}.}

\item{path.shp}{a character string containing the path where are the polygonial
shapefiles (.shp, .dbf and .shx) to plot the maps of the typologies. If NULL, the working directory is used.}

\item{name.ind.shp}{a character string containing the identifier of observations in the dbf file.}

\item{save.pdf}{a boolean, if TRUE, graphics obtained are saved in pdf format. Default is FALSE.}

\item{path.pdf}{if save.pdf=TRUE, a character string containing
the path where the user wishes to save generated pdf files.
 Default is the working directory.}

\item{...}{other arguments to be passed}
}
\value{
{} {different results and map about the result of the clustering.
 When the \code{plot} method is used with \code{choice = "quality"} numerical
  values corresponding to the quality plot are also returned.}
}
\description{
This function provide some results of several clustering obtained with \code{hclustgeo}
}

