% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icp.torus.R
\name{icp.torus.score}
\alias{icp.torus.score}
\title{Conformity score for inductive prediction sets}
\usage{
icp.torus.score(
  data,
  split.id = NULL,
  method = c("all", "kde", "mixture", "kmeans"),
  mixturefitmethod = c("circular", "axis-aligned", "general", "Bayesian"),
  kmeansfitmethod = c("homogeneous-circular", "heterogeneous-circular", "ellipsoids",
    "general"),
  init = c("kmeans", "hierarchical"),
  additional.condition = TRUE,
  param = list(J = 4, concentration = 25),
  kmax = 500,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = TRUE
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}
or \eqn{[-\pi, \pi)^d}}

\item{split.id}{a n-dimensinal vector consisting of values 1 (estimation)
and 2(evaluation)}

\item{method}{A string. One of "all", "kde", "mixture", and "kmeans" which
determines the model or estimation methods. If "kde", the model is based
on the kernel density estimates. It supports the kde-based conformity score
only. If "mixutre", the model is based on the von Mises mixture, fitted
with an EM algorithm. It supports the von Mises mixture and its variants
based conformity scores. If "kmeans", the model is also based on the von
Mises mixture, but the parameter estimation is implemented with the
elliptical k-means algorithm illustrated in Appendix. It supports the
log-max-mixture based conformity score only. Default is "all". If the
dimension of data space is greater than 2, only "kmeans" is supported.}

\item{mixturefitmethod}{A string. One of "circular", "axis-aligned", and
"general" which determines the constraint of the EM fitting. Default is
"axis-aligned". This argument only works for \code{method = "mixture"}.}

\item{kmeansfitmethod}{A string. One of "general", ellipsoids",
"heterogeneous-circular" or "homogeneous-circular". If "general", the
elliptical k-means algorithm with no constraint is used. If "ellipsoids",
only the one iteration of the algorithm is used. If"heterogeneous-circular",
the same as above, but with the constraint that ellipsoids must be spheres.
If "homogeneous-circular", the same as above but the radii of the spheres are
identical. This argument only works for method = "kmeans".}

\item{init}{determine the initial parameter of "kmeans" method,
for option "general". Must be "kmeans" or "hierarchical".
If "kmeans", the initial parameters are obtained with extrinsic kmeans
method.
If "hierarchical", the initial parameters are obtained with hierarchical
clustering method.
Default is "kmeans".}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scaled identity.}

\item{param}{the number of components for mixture fitting and the concentration
parameter in the form of \code{list(J=j, concentration=k)}.}

\item{kmax}{the maximal number of kappa. If estimated kappa is
larger than \code{kmax}, then put kappa as \code{kmax}.}

\item{THRESHOLD}{number for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Moreover, if \code{additional.condition} is
\code{TRUE}, the warning message will be reported.}
}
\value{
returns an \code{icp.torus} object, containing all values
  to compute the conformity score.
}
\description{
\code{icp.torus.score} prepares all values
  for computing the conformity score for specified methods.
}
\examples{
\donttest{
data <- toydata1[, 1:2]

icp.torus <- icp.torus.score(data, method = "all",
                             mixturefitmethod = "general",
                             kmeansfitmethod = "general",
                             param = list(J = 4, concentration = 25))
}
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
