% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffdi.R
\name{fffdi}
\alias{fffdi}
\title{Finnish Forest Fire Danger Index}
\usage{
fffdi(pr, pet, Wvol.init = 0.5, z = 60)
}
\arguments{
\item{pr}{A vector of daily precipitation (in mm)}

\item{pet}{A vector of daily (potential) evapotranspiration data (in mm).}

\item{Wvol.init}{Initialization value for volumetric moisture, in the range 0.1-0.5. Default to 0.5 (very wet soil), but see Details.}

\item{z}{reference surface layer thickness (mm). Default to 60.}
}
\value{
A numeric vector containing FFFDI time series
}
\description{
Implementation of the FFFDI for vector data
}
\details{
\strong{Volumetric moisture}
The default is 0.5, indicating that the soil is very wet and near field capacity. This is so, assuming that the
 index is started in early spring. This value is applied to all locations as a spatially constant initialization value.
 However, Vajda \emph{et al.} (2014, Table 1) provide reference values for different soil moisture conditions. This value ranges
 from 0.1 (very dry) to 0.5 (very wet).
}
\references{
Vajda, A., Venalainen, A., Suomi, I., Junila, P. and Makela, H., 2014. Assessment of forest 
fire danger in a boreal forest environment: description and evaluation of the operational 
system applied in Finland. Meteorol. Appl., 21: 879-887, DOI: 10.1002/met.1425
}
\author{
Joaquin Bedia-Jiménez
}
\keyword{internal}
