% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactify_matrix.R
\name{compactify_matrix}
\alias{compactify_matrix}
\title{Collapses matrix to unique character state distributions}
\usage{
compactify_matrix(cladistic_matrix, message = TRUE)
}
\arguments{
\item{cladistic_matrix}{The cladistic matrix in the format imported by \link{read_nexus_matrix}.}

\item{message}{Logical indicating whether or not a message should be printed to the screen if the matrix cannot be compactified.}
}
\description{
Collapses a cladistic matrix to just unique character state distributions and taxon names.
}
\details{
Important: not recommended for general use.

This function is intended to make a matrix with redundant character state distributions smaller by collapsing these to single characters and upweighting them accordingly. It is intended purely for use with MRP matrices, but may have some very restricted uses elsewhere.

The function also deletes any characters weighted zero from the matrix and will merge duplicate taxon names into unique character strings.
}
\examples{

# Examine the matrix pre-compactification:
michaux_1989$matrix_1$matrix

# Examine the weights pre-compactification:
michaux_1989$matrix_1$character_weights

# Compactify the matrix:
michaux_1989compact <- compactify_matrix(michaux_1989)

# Examine the matrix post-compactification:
michaux_1989compact$matrix_1$matrix

# Examine the weights post-compactification:
michaux_1989compact$matrix_1$character_weights
}
\seealso{
\link{build_cladistic_matrix}, \link{prune_cladistic_matrix}, \link{read_nexus_matrix}, \link{safe_taxonomic_reduction}, \link{write_nexus_matrix}, \link{write_tnt_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
