/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.jayes.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> keyValue = new HashMap();
    private final Map<V, K> valueKey = new HashMap<V, K>();

    @Override
    public int size() {
        return this.keyValue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyValue.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyValue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueKey.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.keyValue.get(key);
    }

    public K getKey(V value) {
        return this.valueKey.get(value);
    }

    @Override
    public V put(K key, V value) {
        if (this.containsValue(value) && this.valueKey.get(value) != key) {
            throw new IllegalArgumentException(value + " has already been assigned an other key, violating uniqueness");
        }
        V val = this.keyValue.put(key, value);
        this.valueKey.remove(val);
        this.valueKey.put(value, key);
        return val;
    }

    @Override
    public V remove(Object key) {
        V v = this.keyValue.remove(key);
        this.valueKey.remove(v);
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> ent : m.entrySet()) {
            this.put(ent.getKey(), ent.getValue());
        }
    }

    @Override
    public void clear() {
        this.keyValue.clear();
        this.valueKey.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.keyValue.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.valueKey.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.keyValue.entrySet();
    }
}

