% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic_model.R
\name{dynamic_model}
\alias{dynamic_model}
\title{Dynamic Model}
\usage{
dynamic_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill for each temperature (TRUE is default).}
}
\value{
The function returns values the chill for each temperature of vector (Total = FALSE), or returns the chill accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation with dynamic equation (two-steps).
}
\details{
The model is based on dynamic accumulation, by means of the relationship between temperatures. The dynamic model assumes that the accumulated chill-units are not annulled by high temperatures.
}
\note{
Code adapted from the function \code{\link[chillR]{Dynamic_Model}}, of the \href{https://CRAN.R-project.org/package=chillR}{chillR} Package
}
\examples{

x <- rnorm(500, 10, 5)
dynamic_model(x)
dynamic_model(x, FALSE)

}
\references{
FISHMAN, Svetlana, EREZ, A. & COUVILLON, G. A. (1987). The Temperature Dependence of Dormancy Breaking in Plants: Computer Simulation of Processes Studied Under Controlled Temperatures. J. Theor. Biol.

LUEDELING, Eike  (2018). chillR: Statistical Methods for Phenology Analysis in Temperate Fruit Trees. R package version 0.70.12. \url{https://CRAN.R-project.org/package=chillR}
}
