% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2Loadings.R
\name{plot2Loadings}
\alias{plot2Loadings}
\title{Plot PCA Loadings from a Spectra Object Against Each Other}
\usage{
plot2Loadings(spectra, pca, loads = c(1, 2), tol = 0.05, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{pca}{An object of class \code{\link{prcomp}}, modified to include a
list element called \code{$method}, a character string describing the
pre-processing carried out and the type of PCA performed (it appears on the
plot).  This is automatically provided if \code{ChemoSpec} functions
\code{\link{c_pcaSpectra}} or \code{\link{r_pcaSpectra}} were used to create
\code{pca}.}

\item{loads}{A vector of two integers specifying which loading vectors to
plot.}

\item{tol}{A number describing the fraction of points to be labeled. \code{tol = 1.0} labels all the points; \code{tol = 0.05} labels \emph{approximately} the most extreme 5 percent. Set to \code{'none'} to completely suppress labels. Note that a simple approach based upon quantiles is used, assumes that both x and y are each normally distributed, and treats x and y separately.  Thus, this is not a formal treatment of outliers, just a means of labeling points. Groups are lumped together for the computation.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link[=GraphicsOptions]{GraphicsOptions()}}).
\itemize{
\item \code{base}: None.  Side effect is a plot.
\item \code{ggplot2}: The plot is displayed, and a \code{ggplot2} object is returned if the value is assigned.  The plot can be modified in the usual \code{ggplot2} manner.
}
}
\description{
Plots two PCA loadings specified by the user, and labels selected (extreme)
points.  Typically used to determine which variables (frequencies) are
co-varying, although in spectroscopy most peaks are represented by several
variables and hence there is a lot of co-varying going on.  Also useful to
determine which variables are contributing the most to the clustering on a
score plot.
}
\examples{

# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(SrE.IR)
pca <- c_pcaSpectra(SrE.IR)
myt <- expression(bolditalic(Serenoa) ~ bolditalic(repens) ~ bold(IR ~ Spectra))
p <- res <- plot2Loadings(SrE.IR, pca, loads = c(1, 2), tol = 0.001)
p <- p + ggtitle(myt)
p

}
\seealso{
See \code{\link{plotLoadings}} to plot one loading against the
original variable (frequency) axis.  See \code{\link{sPlotSpectra}} for
a different approach.  Additional documentation at
\url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{hplot}
\keyword{multivariate}
