% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowDist.R
\name{rowDist}
\alias{rowDist}
\title{Compute Distance Between Rows of a Matrix}
\usage{
rowDist(x, method)
}
\arguments{
\item{x}{A matrix whose rows will be used for the distance calculation.}

\item{method}{A character; one of \code{c("pearson", "correlation",
"spearman", "kendall", "euclidean", "maximum", "manhattan",
"canberra","binary", "minkowski", "cosine")}.}
}
\value{
An object of class \code{dist}.
}
\description{
This function is a wrapper to compute the distance between rows of a matrix
using a number of methods.  Some of these are available in package
\code{\link{stats}} and some in \code{\link[amap]{Dist}} from package \pkg{amap}.
This function determines which method is requested and then the
distance calculation is done by the appropriate method. The exception is the
cosine distance which is calculated locally.
}
\details{
Methods \code{c("euclidean", "maximum", "manhattan", "canberra","binary",
"minkowski")} are sent to function \code{\link{dist}} in package
\code{\link{stats}} while methods \code{c("pearson", "correlation",
"spearman", "kendall")} are handled by \code{Dist} in package \code{amap}.
See the respective help pages for details. \code{"cosine"} is handled
locally.
}
\author{
Bryan A. Hanson, DePauw University.
Suggested by and original code written by Roberto Canteri.
}
\keyword{utilities}
