% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{st_within}
\alias{st_within}
\title{Get string between two regular expression patterns}
\usage{
st_within(
  x,
  left = "[^_[:^punct:]]|\\\\b",
  right = "\\\\[",
  rm_left = 0,
  rm_right = -1
)
}
\arguments{
\item{x}{A character string.}

\item{left}{A character string. Regular expression to serve as look ahead.}

\item{right}{A character string. Regular expression to
serve as a look behind.}

\item{rm_left}{An integer. Number of bites after left-side match to remove
from result. Defaults to -1.}

\item{rm_right}{An integer. Number of bites after right-side match to remove
from result. Defaults to 0.}
}
\value{
A character vector.
}
\description{
Returns a substring enclosed by two regular expression patterns.
By default returns the name of the arguments being indexed by
squared brackets (\code{[]}) in a string containing an expression.
}
\examples{
a <- '(XX[Y=0] == 1) > (XX[Y=1] == 0)'
CausalQueries:::st_within(a)
b <- '(XXX[[Y=0]] == 1 + XXX[[Y=1]] == 0)'
CausalQueries:::st_within(b)
}
\keyword{internal}
