% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_restrictions.R
\name{restrict_by_query}
\alias{restrict_by_query}
\title{Reduce nodal types using statement}
\usage{
restrict_by_query(model, statement, join_by = "|", given = NULL, keep = FALSE)
}
\arguments{
\item{model}{a model created by make_model()}

\item{statement}{a list of character vectors specifying nodal types to be
removed from the model. Use \code{get_nodal_types} to see syntax.}

\item{join_by}{A string or a list of strings. The logical operator joining
expanded types when \code{statement} contains wildcard (\code{.}).
Can take values \code{'&'} (logical AND) or \code{'|'} (logical OR).
When restriction contains wildcard (\code{.}) and \code{join_by} is not
specified, it defaults to \code{'|'}, otherwise it defaults to \code{NULL}.}

\item{given}{A character vector or list of character vectors specifying
nodes on which the parameter set to be restricted depends. \code{given}
must either be NULL or of the same length as \code{statement}. When mixing
statements that are further restricted by \code{given} and ones that are
not, statements without \code{given} restrictions should have \code{given}
specified as one of \code{NULL}, \code{NA}, \code{""} or \code{" "}.}

\item{keep}{Logical. If `FALSE`, removes and if `TRUE` keeps only
causal types specified by \code{restriction}.}
}
\value{
A list with two components: 1. a vector with parameters names of
  parameters implicated by the restrictions, 2. a vector of subsetting
  instructions used to identify implicated causal types
}
\description{
Reduce nodal types using statement
}
\seealso{
Other restrictions: 
\code{\link{restrict_by_labels}()},
\code{\link{set_restrictions}()}
}
\concept{restrictions}
\keyword{internal}
