% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_helpers.R
\name{te}
\alias{te}
\title{Make treatment effect statement (positive)}
\usage{
te(X, Y)
}
\arguments{
\item{X}{A character. The quoted name of the input node}

\item{Y}{A character. The quoted name of the outcome node}
}
\value{
A character statement of class \code{statement}
}
\description{
Generate a statement for (Y(1) - Y(0)). This statement when applied to a model returns an element in (1,0,-1) and not a set of cases. This is useful for some purposes such as querying a model, but not for uses that require a list of types, such as \code{set_restrictions}.
}
\examples{
\donttest{
te('A', 'B')

model <- make_model('X->Y') \%>\% set_restrictions(increasing('X', 'Y'))
query_model(model, list(ate = te('X', 'Y')),  using = 'parameters')

# set_restrictions  breaks with te because it requires a listing
# of causal types, not numeric output.
}
\dontrun{
model <- make_model('X->Y') \%>\% set_restrictions(te('X', 'Y'))
}

}
\seealso{
Other statements: 
\code{\link{complements}()},
\code{\link{decreasing}()},
\code{\link{increasing}()},
\code{\link{interacts}()},
\code{\link{non_decreasing}()},
\code{\link{non_increasing}()},
\code{\link{substitutes}()}
}
\concept{statements}
