CatDynFit <-
function(x, p, par, dates, distr, method, control=list(), hessian=TRUE, itnmax)
          {
          cat("\nLikelihood maximization calling the optimx() wrapper\nBEWARE: it make take several minutes, and with dozens, hundreds of parameters, model fit may take hours on a PC\n \n")
          options(warn=-1)
          fleet.name <- x$Properties$Fleets$Fleet
          distr.set  <- c("normal","apnormal","lognormal","aplnormal","poisson","gamma","negbin")
          if(class(x) != "CatDynData") {stop("Pass an object of class CatDynData as first argument - see the help for as.CatDynData")}
          if(sum(sort(p) == p)<length(p)) {stop("Number of perturbations per fleet must not be arranged in descending order")}
          if(any(is.na(p))) {stop("NAs are not allowed in the perturbations per fleet vector 'p'")}
          if(length(p) < 1 || length(p) > 2) {stop("The integer vector 'p' determines the number of perturbations per fleet; its length must be 1 for single fleet, or 2 for two fleets")}
          if(any(p < -20) || any(p > 100)) {stop("The number of perturbations per fleet shall not be less than -20 (transit fisheries) nor higher than 100")}
          if(class(p) != "numeric") {stop("'p' must be a numeric vector")}
          if(any(is.na(par))) {stop("NAs are not allowed in the parameter vector 'par'")}
          if(length(par) < 4 || length(par) > 208) {stop("For any of the model versions the number of parameters is > 4 and < 208")}
          if(class(par) != "numeric") {stop("'par' must be a numeric vector")}
          if(any(is.na(dates))){stop("NAs are not allowed in the dates vector")}
          if(p >= 0)
            {
             if(sum(sort(p) == p)<length(p)) {stop("Number of perturbations per fleet must not be arranged in descending order")}
             if(length(dates) != (sum(p)+2)) {stop("The dates vector must contain initial time step, time steps of first fleet in ascending order, time step of second (if any) fleet in ascending order, and final time step. The first fleet may not have more perturbations than the second fleet. With up to 5 perturbations in any fleet, any combination of perturbations is allowed, p=c(0,1), ..., c(3,5), ..., c(5,5); but from 6 up to 100 both fleets must have the same number of perturbations")}
            }
          else
            {
            if(length(dates) != (2*abs(p)+2)) {stop("The dates vector must contain initial time step, time step of entry of each perturbation immediantely followed by time step of its exit, for all perturbations ordered by time of entry, and final time step")}
            }           
          #if(class(dates) != "integer") {stop("'dates' must be a vector of integers")}
          if(dates[1] > dates[2]) {stop("Initial date must be less than next date")}
          if(tail(dates,1) < tail(dates,2)[1]) {stop("Final date must not be less than previous date")}
          if(!distr%in%distr.set) {stop("'distr' must be 'normal','apnormal','lognormal','aplnormal', 'gamma', 'poisson', or 'negbin', see help pages for CatDynFit")}
          if(length(fleet.name) == 1)  #One Fleet
            {
             #if(sum(sort(dates) == dates)<length(dates)){stop("Dates must be arranged in ascending order")} 
             if(length(p) != 1)
               {
                stop("For a 1-fleet model 'p' must be of length 1")
               }
             #pure depletion
             if(p == 0)
                {
                 if(length(dates) != 2) {stop("For a 1-fleet 0P (pure depletion) model 'dates' must be a vector of length 2")}
                 if(length(par) != 5) {stop("For a 1-fleet 0P (pure depletion) model 'par' must be a vector of length 5")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.end");
                    par.names                      <- c("M","N0",paste(c("k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev         <- NA;
                       results2[[i]]$Cor              <- matrix(NA,length(par.names),length(par.names));
                      }
                    else
                      {
                       results2[[i]]$converg          <- results1[i,length(par)+5];
                       results2[[i]]$kkt              <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC              <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par           <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads        <- temp[i,]$ngatend;
                                             v        <- matrix(0,length(par.names),length(par.names));
                                             v        <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5)),
                                                                     mean=as.numeric(results1[i,1:length(par)]),
                                                                     cov=try(solve(temp[i,]$nhatend)),
                                                                     ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #1P
             else if(p == 1)
                {
                 if(length(dates) != 3) {stop("For a 1-fleet 1P model 'dates' must be a vector of length 3")}
                 if(length(par) != 6) {stop("For a 1-fleet 1P model 'par' must be a vector of length 6")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
              else if(p == -1)
                {
                 if(length(dates) != 4) {stop("For a 1-fleet 1P transit model 'dates' must be a vector of length 4")}
                 if(length(par) != 6) {stop("For a 1-fleet 1P transit model 'par' must be a vector of length 6")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #2P
             else if(p == 2)
                {
                 if(length(dates) != 4) {stop("For a 1-fleet 2P model 'dates' must be a vector of length 4")}
                 if(length(par) != 7) {stop("For a 1-fleet 2P model 'par' must be a vector of length 7")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)                       
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);                                                                         
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }                                                   
                    }
                rm(v);
                rm(temp);
                }
             else if(p == -2)
                {
                 if(length(dates) != 6) {stop("For a 1-fleet 2P transit model 'dates' must be a vector of length 6")}
                 if(length(par) != 7) {stop("For a 1-fleet 2P transit model 'par' must be a vector of length 7")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P1.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);                                                                         
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }                                                   
                    }
                rm(v);
                rm(temp);
                }
             #3P
             else if(p == 3)
                {
                 if(length(dates) != 5) {stop("For a 1-fleet 3P model 'dates' must be a vector of length 5")}
                 if(length(par) != 8) {stop("For a 1-fleet 3P model 'par' must be a vector of length 8")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -3)
                {
                 if(length(dates) != 8) {stop("For a 1-fleet 3P transit model 'dates' must be a vector of length 8")}
                 if(length(par) != 8) {stop("For a 1-fleet 3P transit model 'par' must be a vector of length 8")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #4P
             else if(p == 4)
                {
                 if(length(dates) != 6) {stop("For a 1-fleet 4P model 'dates' must be a vector of length 6")}
                 if(length(par) != 9) {stop("For a 1-fleet 4P model 'par' must be a vector of length 9")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v)
                 rm(temp);
                }
             else if(p == -4)
                {
                 if(length(dates) != 10) {stop("For a 1-fleet 4P transit model 'dates' must be a vector of length 10")}
                 if(length(par) != 9) {stop("For a 1-fleet 4P transdt model 'par' must be a vector of length 9")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #5P
             else if(p == 5)
                {
                 if(length(dates) != 7) {stop("For a 1-fleet 5P model 'dates' must be a vector of length 7")}
                 if(length(par) != 10) {stop("For a 1-fleet 5P model 'par' must be a vector of length 10")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev         <- rep(NA, length(par.names))
                       results2[[i]]$Cor              <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -5)
                {
                 if(length(dates) != 12) {stop("For a 1-fleet 5P transit model 'dates' must be a vector of length 12")}
                 if(length(par) != 10) {stop("For a 1-fleet 5P transit model 'par' must be a vector of length 10")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev         <- rep(NA, length(par.names))
                       results2[[i]]$Cor              <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev        <- sqrt(diag(v));
                       results2[[i]]$Cor             <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 6)
                {
                 if(length(dates) != 8) {stop("For a 1-fleet 6P model 'dates' must be a vector of length 8")}
                 if(length(par) != 11) {stop("For a 1-fleet 6P model 'par' must be a vector of length 11")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                              ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                              ~exp(x11)),
                                                                       mean=as.numeric(results1[i,1:length(par)]),
                                                                       cov=try(solve(temp[i,]$nhatend)),
                                                                       ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v)
                 rm(temp);
                }
             else if(p == -6)
                {
                 if(length(dates) != 14) {stop("For a 1-fleet 6P transit model 'dates' must be a vector of length 14")}
                 if(length(par) != 11) {stop("For a 1-fleet 6P transit model 'par' must be a vector of length 11")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                              ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                              ~exp(x11)),
                                                                       mean=as.numeric(results1[i,1:length(par)]),
                                                                       cov=try(solve(temp[i,]$nhatend)),
                                                                       ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 7)
                {
                 if(length(dates) != 9) {stop("For a 1-fleet 7P model 'dates' must be a vector of length 9")}
                 if(length(par) != 12) {stop("For a 1-fleet 7P model 'par' must be a vector of length 12")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -7)
                {
                 if(length(dates) != 16) {stop("For a 1-fleet 7P transit model 'dates' must be a vector of length 16")}
                 if(length(par) != 12) {stop("For a 1-fleet 7P transit model 'par' must be a vector of length 12")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 8)
                {
                 if(length(dates) != 10) {stop("For a 1-fleet 8P model 'dates' must be a vector of length 10")}
                 if(length(par) != 13) {stop("For a 1-fleet 8P model 'par' must be a vector of length 13")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -8)
                {
                 if(length(dates) != 18) {stop("For a 1-fleet 8P transit model 'dates' must be a vector of length 18")}
                 if(length(par) != 13) {stop("For a 1-fleet 8P transit model 'par' must be a vector of length 13")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 9)
                {
                 if(length(dates) != 11) {stop("For a 1-fleet 9P model 'dates' must be a vector of length 11")}
                 if(length(par) != 14) {stop("For a 1-fleet 9P model 'par' must be a vector of length 14")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp)
                }
             else if(p == -9)
                {
                 if(length(dates) != 20) {stop("For a 1-fleet 9P transit model 'dates' must be a vector of length 20")}
                 if(length(par) != 14) {stop("For a 1-fleet 9P transit model 'par' must be a vector of length 14")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","k.","alpha.","beta."),sort(rep(fleet.name,3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 10)
                {
                 if(length(dates) != 12) {stop("For a 1-fleet 10P model 'dates' must be a vector of length 12")}
                 if(length(par) != 15) {stop("For a 1-fleet 10P model 'par' must be a vector of length 15")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -10)
                {
                 if(length(dates) != 22) {stop("For a 1-fleet 10P transit model 'dates' must be a vector of length 22")}
                 if(length(par) != 15) {stop("For a 1-fleet 10P transit model 'par' must be a vector of length 15")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 11)
                {
                 if(length(dates) != 13) {stop("For a 1-fleet 11P model 'dates' must be a vector of length 13")}
                 if(length(par) != 16) {stop("For a 1-fleet 11P model 'par' must be a vector of length 16")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -11)
                {
                 if(length(dates) != 24) {stop("For a 1-fleet 11P transit model 'dates' must be a vector of length 24")}
                 if(length(par) != 16) {stop("For a 1-fleet 11P transit model 'par' must be a vector of length 16")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 12)
                {
                 if(length(dates) != 14) {stop("For a 1-fleet 12P model 'dates' must be a vector of length 14")}
                 if(length(par) != 17) {stop("For a 1-fleet 12P model 'par' must be a vector of length 17")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -12)
                {
                 if(length(dates) != 26) {stop("For a 1-fleet 12P transit model 'dates' must be a vector of length 26")}
                 if(length(par) != 17) {stop("For a 1-fleet 12P transit model 'par' must be a vector of length 17")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 13)
                {
                 if(length(dates) != 15) {stop("For a 1-fleet 13P model 'dates' must be a vector of length 15")}
                 if(length(par) != 18) {stop("For a 1-fleet 13P model 'par' must be a vector of length 18")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -13)
                {
                 if(length(dates) != 28) {stop("For a 1-fleet 13P transit model 'dates' must be a vector of length 28")}
                 if(length(par) != 18) {stop("For a 1-fleet 13P transit model 'par' must be a vector of length 18")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 14)
                {
                 if(length(dates) != 16) {stop("For a 1-fleet 14P model 'dates' must be a vector of length 16")}
                 if(length(par) != 19) {stop("For a 1-fleet 14P model 'par' must be a vector of length 19")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -14)
                {
                 if(length(dates) != 30) {stop("For a 1-fleet 14P transit model 'dates' must be a vector of length 30")}
                 if(length(par) != 19) {stop("For a 1-fleet 14P transit model 'par' must be a vector of length 19")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 15)
                {
                 if(length(dates) != 17) {stop("For a 1-fleet 15P model 'dates' must be a vector of length 17")}
                 if(length(par) != 20) {stop("For a 1-fleet 15P model 'par' must be a vector of length 20")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.P15","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -15)
                {
                 if(length(dates) != 32) {stop("For a 1-fleet 15P transit model 'dates' must be a vector of length 17")}
                 if(length(par) != 20) {stop("For a 1-fleet 15P transit model 'par' must be a vector of length 20")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.P15.entry","ts.P15.exit",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 16)
                {
                 if(length(dates) != 18) {stop("For a 1-fleet 16P model 'dates' must be a vector of length 18")}
                 if(length(par) != 21) {stop("For a 1-fleet 16P model 'par' must be a vector of length 21")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.P15","ts.P16","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -16)
                {
                 if(length(dates) != 34) {stop("For a 1-fleet 16P transit model 'dates' must be a vector of length 34")}
                 if(length(par) != 21) {stop("For a 1-fleet 16P transit model 'par' must be a vector of length 21")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.P15.entry","ts.P15.exit",
                                                        "ts.P16.entry","ts.P16.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 17)
                {
                 if(length(dates) != 19) {stop("For a 1-fleet 17P model 'dates' must be a vector of length 19")}
                 if(length(par) != 22) {stop("For a 1-fleet 17P model 'par' must be a vector of length 22")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.P15","ts.P16","ts.P17","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -17)
                {
                 if(length(dates) != 36) {stop("For a 1-fleet 17P transit model 'dates' must be a vector of length 36")}
                 if(length(par) != 22) {stop("For a 1-fleet 17P model 'par' must be a vector of length 22")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.P15.entry","ts.P15.exit",
                                                        "ts.P16.entry","ts.P16.exit","ts.P17.entry","ts.P17.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 18)
                {
                 if(length(dates) != 20) {stop("For a 1-fleet 18P model 'dates' must be a vector of length 20")}
                 if(length(par) != 23) {stop("For a 1-fleet 18P model 'par' must be a vector of length 23")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,3], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -18)
                {
                 if(length(dates) != 38) {stop("For a 1-fleet 18P transit model 'dates' must be a vector of length 38")}
                 if(length(par) != 23) {stop("For a 1-fleet 18P transit model 'par' must be a vector of length 23")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,3], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.P15.entry","ts.P15.exit",
                                                        "ts.P16.entry","ts.P16.exit","ts.P17.entry","ts.P17.exit","ts.P18.entry","ts.P18.exit",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 19)
                {
                 if(length(dates) != 21) {stop("For a 1-fleet 19P model 'dates' must be a vector of length 21")}
                 if(length(par) != 24) {stop("For a 1-fleet 19P model 'par' must be a vector of length 24")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","P19.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -19)
                {
                 if(length(dates) != 40) {stop("For a 1-fleet 19P transit model 'dates' must be a vector of length 40")}
                 if(length(par) != 24) {stop("For a 1-fleet 19P transit model 'par' must be a vector of length 24")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.P15.entry","ts.P15.exit",
                                                        "ts.P16.entry","ts.P16.exit","ts.P17.entry","ts.P17.exit","ts.P18.entry","ts.P18.exit",
                                                        "ts.P19.entry","ts.P19.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","P19.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 20)
                {
                 if(length(dates) != 22) {stop("For a 1-fleet 20P model 'dates' must be a vector of length 22")}
                 if(length(par) != 25) {stop("For a 1-fleet 20P model 'par' must be a vector of length 25")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6",
                                                        "ts.P7","ts.P8","ts.P9","ts.P10","ts.P11","ts.P12","ts.P13",
                                                        "ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","P19.","P20.","k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == -20)
                {
                 if(length(dates) != 42) {stop("For a 1-fleet 20P transit model 'dates' must be a vector of length 22")}
                 if(length(par) != 25) {stop("For a 1-fleet 20P transit model 'par' must be a vector of length 25")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMNT',as.character(abs(p)),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1.entry","ts.P1.exit","ts.P2.entry","ts.P2.exit","ts.P3.entry","ts.P3.exit",
                                                        "ts.P4.entry","ts.P4.exit","ts.P5.entry","ts.P5.exit","ts.P6.entry","ts.P6.exit",
                                                        "ts.P7.entry","ts.P7.exit","ts.P8.entry","ts.P8.exit","ts.P9.entry","ts.P9.exit",
                                                        "ts.P10.entry","ts.P10.exit","ts.P11.entry","ts.P11.exit","ts.P12.entry","ts.P12.exit",
                                                        "ts.P13.entry","ts.P13.exit","ts.P14.entry","ts.P14.exit","ts.P15.entry","ts.P15.exit",
                                                        "ts.P16.entry","ts.P16.exit","ts.P17.entry","ts.P17.exit","ts.P18.entry","ts.P18.exit",
                                                        "ts.P19.entry","ts.P19.exit","ts.P20.entry","ts.P20.exit","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","P19.","P20.","k.","alpha.","beta."),sort(rep(fleet.name,3+3+abs(p))),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 21)
                {
                 if(length(dates) != 23) {stop("For a 1-fleet 21P model 'dates' must be a vector of length 23")}
                 if(length(par) != 26) {stop("For a 1-fleet 21P model 'par' must be a vector of length 26")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 22)
                {
                 if(length(dates) != 24) {stop("For a 1-fleet 22P model 'dates' must be a vector of length 24")}
                 if(length(par) != 27) {stop("For a 1-fleet 22P model 'par' must be a vector of length 27")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 23)
                {
                 if(length(dates) != 25) {stop("For a 1-fleet 23P model 'dates' must be a vector of length 25")}
                 if(length(par) != 28) {stop("For a 1-fleet 23P model 'par' must be a vector of length 28")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag());
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 24)
                {
                 if(length(dates) != 26) {stop("For a 1-fleet 24P model 'dates' must be a vector of length 26")}
                 if(length(par) != 29) {stop("For a 1-fleet 24P model 'par' must be a vector of length 29")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 25)
                {
                 if(length(dates) != 27) {stop("For a 1-fleet 25P model 'dates' must be a vector of length 27")}
                 if(length(par) != 30) {stop("For a 1-fleet 25P model 'par' must be a vector of length 30")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE) 
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 26)
                {
                 if(length(dates) != 28) {stop("For a 1-fleet 26P model 'dates' must be a vector of length 28")}
                 if(length(par) != 31) {stop("For a 1-fleet 26P model 'par' must be a vector of length 31")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 27)
                {
                 if(length(dates) != 29) {stop("For a 1-fleet 27P model 'dates' must be a vector of length 29")}
                 if(length(par) != 32) {stop("For a 1-fleet 27P model 'par' must be a vector of length 32")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 28)
                {
                 if(length(dates) != 30) {stop("For a 1-fleet 28P model 'dates' must be a vector of length 30")}
                 if(length(par) != 33) {stop("For a 1-fleet 28P model 'par' must be a vector of length 33")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 29)
                {
                 if(length(dates) != 31) {stop("For a 1-fleet 29P model 'dates' must be a vector of length 31")}
                 if(length(par) != 34) {stop("For a 1-fleet 29P model 'par' must be a vector of length 34")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 30)
                {
                 if(length(dates) != 32) {stop("For a 1-fleet 30P model 'dates' must be a vector of length 32")}
                 if(length(par) != 35) {stop("For a 1-fleet 30P model 'par' must be a vector of length 35")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 31)
                {
                 if(length(dates) != 33) {stop("For a 1-fleet 31P model 'dates' must be a vector of length 33")}
                 if(length(par) != 36) {stop("For a 1-fleet 31P model 'par' must be a vector of length 36")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 32)
                {
                 if(length(dates) != 34) {stop("For a 1-fleet 32P model 'dates' must be a vector of length 34")}
                 if(length(par) != 37) {stop("For a 1-fleet 32P model 'par' must be a vector of length 37")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 33)
                {
                 if(length(dates) != 35) {stop("For a 1-fleet 33P model 'dates' must be a vector of length 35")}
                 if(length(par) != 38) {stop("For a 1-fleet 33P model 'par' must be a vector of length 38")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 34)
                {
                 if(length(dates) != 36) {stop("For a 1-fleet 34P model 'dates' must be a vector of length 36")}
                 if(length(par) != 39) {stop("For a 1-fleet 34P model 'par' must be a vector of length 39")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 35)
                {
                 if(length(dates) != 37) {stop("For a 1-fleet 35P model 'dates' must be a vector of length 37")}
                 if(length(par) != 40) {stop("For a 1-fleet 35P model 'par' must be a vector of length 40")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 36)
                {
                 if(length(dates) != 38) {stop("For a 1-fleet 36P model 'dates' must be a vector of length 38")}
                 if(length(par) != 41) {stop("For a 1-fleet 36P model 'par' must be a vector of length 41")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 37)
                {
                 if(length(dates) != 39) {stop("For a 1-fleet 37P model 'dates' must be a vector of length 39")}
                 if(length(par) != 42) {stop("For a 1-fleet 37P model 'par' must be a vector of length 42")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 38)
                {
                 if(length(dates) != 40) {stop("For a 1-fleet 38P model 'dates' must be a vector of length 40")}
                 if(length(par) != 43) {stop("For a 1-fleet 38P model 'par' must be a vector of length 43")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 39)
                {
                 if(length(dates) != 41) {stop("For a 1-fleet 39P model 'dates' must be a vector of length 41")}
                 if(length(par) != 44) {stop("For a 1-fleet 39P model 'par' must be a vector of length 44")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 40)
                {
                 if(length(dates) != 42) {stop("For a 1-fleet 40P model 'dates' must be a vector of length 42")}
                 if(length(par) != 45) {stop("For a 1-fleet 40P model 'par' must be a vector of length 45")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 41)
                {
                 if(length(dates) != 43) {stop("For a 1-fleet 41P model 'dates' must be a vector of length 43")}
                 if(length(par) != 46) {stop("For a 1-fleet 41P model 'par' must be a vector of length 46")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 42)
                {
                 if(length(dates) != 44) {stop("For a 1-fleet 42P model 'dates' must be a vector of length 44")}
                 if(length(par) != 47) {stop("For a 1-fleet 42P model 'par' must be a vector of length 47")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 43)
                {
                 if(length(dates) != 45) {stop("For a 1-fleet 43P model 'dates' must be a vector of length 45")}
                 if(length(par) != 48) {stop("For a 1-fleet 43P model 'par' must be a vector of length 48")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 44)
                {
                 if(length(dates) != 46) {stop("For a 1-fleet 44P model 'dates' must be a vector of length 46")}
                 if(length(par) != 49) {stop("For a 1-fleet 44P model 'par' must be a vector of length 49")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 45)
                {
                 if(length(dates) != 47) {stop("For a 1-fleet 45P model 'dates' must be a vector of length 47")}
                 if(length(par) != 50) {stop("For a 1-fleet 45P model 'par' must be a vector of length 50")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 46)
                {
                 if(length(dates) != 48) {stop("For a 1-fleet 46P model 'dates' must be a vector of length 48")}
                 if(length(par) != 51) {stop("For a 1-fleet 46P model 'par' must be a vector of length 51")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 47)
                {
                 if(length(dates) != 49) {stop("For a 1-fleet 47P model 'dates' must be a vector of length 49")}
                 if(length(par) != 52) {stop("For a 1-fleet 47P model 'par' must be a vector of length 52")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 48)
                {
                 if(length(dates) != 50) {stop("For a 1-fleet 48P model 'dates' must be a vector of length 50")}
                 if(length(par) != 53) {stop("For a 1-fleet 48P model 'par' must be a vector of length 53")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 49)
                {
                 if(length(dates) != 51) {stop("For a 1-fleet 49P model 'dates' must be a vector of length 51")}
                 if(length(par) != 54) {stop("For a 1-fleet 49P model 'par' must be a vector of length 54")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 50)
                {
                 if(length(dates) != 52) {stop("For a 1-fleet 50P model 'dates' must be a vector of length 52")}
                 if(length(par) != 55) {stop("For a 1-fleet 50P model 'par' must be a vector of length 55")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 51)
                {
                 if(length(dates) != 53) {stop("For a 1-fleet 51P model 'dates' must be a vector of length 53")}
                 if(length(par) != 56) {stop("For a 1-fleet 51P model 'par' must be a vector of length 56")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 52)
                {
                 if(length(dates) != 54) {stop("For a 1-fleet 52P model 'dates' must be a vector of length 54")}
                 if(length(par) != 57) {stop("For a 1-fleet 52P model 'par' must be a vector of length 57")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 53)
                {
                 if(length(dates) != 55) {stop("For a 1-fleet 53P model 'dates' must be a vector of length 55")}
                 if(length(par) != 58) {stop("For a 1-fleet 53P model 'par' must be a vector of length 58")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58)),                                                                      
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 54)
                {
                 if(length(dates) != 56) {stop("For a 1-fleet 54P model 'dates' must be a vector of length 56")}
                 if(length(par) != 59) {stop("For a 1-fleet 54P model 'par' must be a vector of length 59")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 55)
                {
                 if(length(dates) != 57) {stop("For a 1-fleet 55P model 'dates' must be a vector of length 57")}
                 if(length(par) != 60) {stop("For a 1-fleet 55P model 'par' must be a vector of length 60")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 56)
                {
                 if(length(dates) != 58) {stop("For a 1-fleet 56P model 'dates' must be a vector of length 58")}
                 if(length(par) != 61) {stop("For a 1-fleet 56P model 'par' must be a vector of length 61")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 57)
                {
                 if(length(dates) != 59) {stop("For a 1-fleet 57P model 'dates' must be a vector of length 59")}
                 if(length(par) != 62) {stop("For a 1-fleet 57P model 'par' must be a vector of length 62")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 58)
                {
                 if(length(dates) != 60) {stop("For a 1-fleet 58P model 'dates' must be a vector of length 60")}
                 if(length(par) != 63) {stop("For a 1-fleet 58P model 'par' must be a vector of length 63")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 59)
                {
                 if(length(dates) != 61) {stop("For a 1-fleet 59P model 'dates' must be a vector of length 61")}
                 if(length(par) != 64) {stop("For a 1-fleet 59P model 'par' must be a vector of length 64")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 60)
                {
                 if(length(dates) != 62) {stop("For a 1-fleet 60P model 'dates' must be a vector of length 62")}
                 if(length(par) != 65) {stop("For a 1-fleet 60P model 'par' must be a vector of length 65")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 61)
                {
                 if(length(dates) != 63) {stop("For a 1-fleet 61P model 'dates' must be a vector of length 63")}
                 if(length(par) != 66) {stop("For a 1-fleet 61P model 'par' must be a vector of length 66")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 62)
                {
                 if(length(dates) != 64) {stop("For a 1-fleet 62P model 'dates' must be a vector of length 64")}
                 if(length(par) != 67) {stop("For a 1-fleet 62P model 'par' must be a vector of length 67")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 63)
                {
                 if(length(dates) != 65) {stop("For a 1-fleet 63P model 'dates' must be a vector of length 65")}
                 if(length(par) != 68) {stop("For a 1-fleet 63P model 'par' must be a vector of length 68")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 64)
                {
                 if(length(dates) != 66) {stop("For a 1-fleet 64P model 'dates' must be a vector of length 66")}
                 if(length(par) != 69) {stop("For a 1-fleet 64P model 'par' must be a vector of length 69")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 65)
                {
                 if(length(dates) != 67) {stop("For a 1-fleet 65P model 'dates' must be a vector of length 67")}
                 if(length(par) != 70) {stop("For a 1-fleet 65P model 'par' must be a vector of length 70")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 66)
                {
                 if(length(dates) != 68) {stop("For a 1-fleet 66P model 'dates' must be a vector of length 68")}
                 if(length(par) != 71) {stop("For a 1-fleet 66P model 'par' must be a vector of length 71")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 67)
                {
                 if(length(dates) != 69) {stop("For a 1-fleet 67P model 'dates' must be a vector of length 69")}
                 if(length(par) != 72) {stop("For a 1-fleet 67P model 'par' must be a vector of length 72")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 68)
                {
                 if(length(dates) != 70) {stop("For a 1-fleet 68P model 'dates' must be a vector of length 70")}
                 if(length(par) != 73) {stop("For a 1-fleet 68P model 'par' must be a vector of length 73")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 69)
                {
                 if(length(dates) != 71) {stop("For a 1-fleet 69P model 'dates' must be a vector of length 71")}
                 if(length(par) != 74) {stop("For a 1-fleet 69P model 'par' must be a vector of length 74")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 70)
                {
                 if(length(dates) != 72) {stop("For a 1-fleet 70P model 'dates' must be a vector of length 72")}
                 if(length(par) != 75) {stop("For a 1-fleet 70P model 'par' must be a vector of length 75")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 71)
                {
                 if(length(dates) != 73) {stop("For a 1-fleet 71P model 'dates' must be a vector of length 73")}
                 if(length(par) != 76) {stop("For a 1-fleet 71P model 'par' must be a vector of length 76")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 72)
                {
                 if(length(dates) != 74) {stop("For a 1-fleet 72P model 'dates' must be a vector of length 74")}
                 if(length(par) != 77) {stop("For a 1-fleet 72P model 'par' must be a vector of length 77")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 73)
                {
                 if(length(dates) != 75) {stop("For a 1-fleet 73P model 'dates' must be a vector of length 75")}
                 if(length(par) != 78) {stop("For a 1-fleet 73P model 'par' must be a vector of length 78")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 74)
                {
                 if(length(dates) != 76) {stop("For a 1-fleet 74P model 'dates' must be a vector of length 76")}
                 if(length(par) != 79) {stop("For a 1-fleet 74P model 'par' must be a vector of length 79")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 75)
                {
                 if(length(dates) != 77) {stop("For a 1-fleet 75P model 'dates' must be a vector of length 77")}
                 if(length(par) != 80) {stop("For a 1-fleet 75P model 'par' must be a vector of length 80")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 76)
                {
                 if(length(dates) != 78) {stop("For a 1-fleet 76P model 'dates' must be a vector of length 78")}
                 if(length(par) != 81) {stop("For a 1-fleet 76P model 'par' must be a vector of length 81")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 77)
                {
                 if(length(dates) != 79) {stop("For a 1-fleet 77P model 'dates' must be a vector of length 79")}
                 if(length(par) != 82) {stop("For a 1-fleet 77P model 'par' must be a vector of length 82")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 78)
                {
                 if(length(dates) != 80) {stop("For a 1-fleet 78P model 'dates' must be a vector of length 80")}
                 if(length(par) != 83) {stop("For a 1-fleet 78P model 'par' must be a vector of length 83")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 79)
                {
                 if(length(dates) != 81) {stop("For a 1-fleet 79P model 'dates' must be a vector of length 81")}
                 if(length(par) != 84) {stop("For a 1-fleet 79P model 'par' must be a vector of length 84")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 80)
                {
                 if(length(dates) != 82) {stop("For a 1-fleet 80P model 'dates' must be a vector of length 82")}
                 if(length(par) != 85) {stop("For a 1-fleet 80P model 'par' must be a vector of length 85")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 81)
                {
                 if(length(dates) != 83) {stop("For a 1-fleet 81P model 'dates' must be a vector of length 83")}
                 if(length(par) != 86) {stop("For a 1-fleet 81P model 'par' must be a vector of length 86")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 82)
                {
                 if(length(dates) != 84) {stop("For a 1-fleet 82P model 'dates' must be a vector of length 84")}
                 if(length(par) != 87) {stop("For a 1-fleet 82P model 'par' must be a vector of length 87")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 83)
                {
                 if(length(dates) != 85) {stop("For a 1-fleet 83P model 'dates' must be a vector of length 85")}
                 if(length(par) != 88) {stop("For a 1-fleet 83P model 'par' must be a vector of length 88")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 84)
                {
                 if(length(dates) != 86) {stop("For a 1-fleet 84P model 'dates' must be a vector of length 86")}
                 if(length(par) != 89) {stop("For a 1-fleet 84P model 'par' must be a vector of length 89")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 85)
                {
                 if(length(dates) != 87) {stop("For a 1-fleet 85P model 'dates' must be a vector of length 87")}
                 if(length(par) != 90) {stop("For a 1-fleet 85P model 'par' must be a vector of length 90")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 86)
                {
                 if(length(dates) != 88) {stop("For a 1-fleet 86P model 'dates' must be a vector of length 88")}
                 if(length(par) != 91) {stop("For a 1-fleet 86P model 'par' must be a vector of length 91")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 87)
                {
                 if(length(dates) != 89) {stop("For a 1-fleet 87P model 'dates' must be a vector of length 89")}
                 if(length(par) != 92) {stop("For a 1-fleet 87P model 'par' must be a vector of length 92")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 88)
                {
                 if(length(dates) != 90) {stop("For a 1-fleet 88P model 'dates' must be a vector of length 90")}
                 if(length(par) != 93) {stop("For a 1-fleet 88P model 'par' must be a vector of length 93")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 89)
                {
                 if(length(dates) != 91) {stop("For a 1-fleet 89P model 'dates' must be a vector of length 91")}
                 if(length(par) != 94) {stop("For a 1-fleet 89P model 'par' must be a vector of length 94")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 90)
                {
                 if(length(dates) != 92) {stop("For a 1-fleet 90P model 'dates' must be a vector of length 92")}
                 if(length(par) != 95) {stop("For a 1-fleet 90P model 'par' must be a vector of length 95")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 91)
                {
                 if(length(dates) != 93) {stop("For a 1-fleet 91P model 'dates' must be a vector of length 93")}
                 if(length(par) != 96) {stop("For a 1-fleet 91P model 'par' must be a vector of length 96")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 92)
                {
                 if(length(dates) != 94) {stop("For a 1-fleet 92P model 'dates' must be a vector of length 94")}
                 if(length(par) != 97) {stop("For a 1-fleet 92P model 'par' must be a vector of length 97")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 93)
                {
                 if(length(dates) != 95) {stop("For a 1-fleet 93P model 'dates' must be a vector of length 95")}
                 if(length(par) != 98) {stop("For a 1-fleet 93P model 'par' must be a vector of length 98")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 94)
                {
                 if(length(dates) != 96) {stop("For a 1-fleet 94P model 'dates' must be a vector of length 96")}
                 if(length(par) != 99) {stop("For a 1-fleet 94P model 'par' must be a vector of length 99")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 95)
                {
                 if(length(dates) != 97) {stop("For a 1-fleet 95P model 'dates' must be a vector of length 97")}
                 if(length(par) != 100) {stop("For a 1-fleet 95P model 'par' must be a vector of length 100")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94","ts.P95",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.","P95.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99),~exp(x100)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 96)
                {
                 if(length(dates) != 98) {stop("For a 1-fleet 96P model 'dates' must be a vector of length 98")}
                 if(length(par) != 101) {stop("For a 1-fleet 96P model 'par' must be a vector of length 101")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94","ts.P95","ts.P96",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.","P95.","P96.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99),~exp(x100),
                                                                      ~exp(x101)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 97)
                {
                 if(length(dates) != 99) {stop("For a 1-fleet 97P model 'dates' must be a vector of length 99")}
                 if(length(par) != 102) {stop("For a 1-fleet 97P model 'par' must be a vector of length 102")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94","ts.P95","ts.P96","ts.P97",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.","P95.","P96.","P97.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99),~exp(x100),
                                                                      ~exp(x101),~exp(x102)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 98)
                {
                 if(length(dates) != 100) {stop("For a 1-fleet 98P model 'dates' must be a vector of length 100")}
                 if(length(par) != 103) {stop("For a 1-fleet 98P model 'par' must be a vector of length 103")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94","ts.P95","ts.P96","ts.P97","ts.P98",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.","P95.","P96.","P97.","P98.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99),~exp(x100),
                                                                      ~exp(x101),~exp(x102),~exp(x103)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 99)
                {
                 if(length(dates) != 101) {stop("For a 1-fleet 99P model 'dates' must be a vector of length 101")}
                 if(length(par) != 104) {stop("For a 1-fleet 99P model 'par' must be a vector of length 104")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94","ts.P95","ts.P96","ts.P97","ts.P98","ts.P99",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.","P95.","P96.","P97.","P98.","P99.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99),~exp(x100),
                                                                      ~exp(x101),~exp(x102),~exp(x103),~exp(x104)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if(p == 100)
                {
                 if(length(dates) != 102) {stop("For a 1-fleet 100P model 'dates' must be a vector of length 102")}
                 if(length(par) != 105) {stop("For a 1-fleet 100P model 'par' must be a vector of length 105")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name]][,2], 
                                                         obscat1=x$Data[[fleet.name]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian, 
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1","ts.P2","ts.P3","ts.P4","ts.P5","ts.P6","ts.P7","ts.P8","ts.P9","ts.P10",
                                                        "ts.P11","ts.P12","ts.P13","ts.P14","ts.P15","ts.P16","ts.P17","ts.P18","ts.P19","ts.P20",
                                                        "ts.P21","ts.P22","ts.P23","ts.P24","ts.P25","ts.P26","ts.P27","ts.P28","ts.P29","ts.P30",
                                                        "ts.P31","ts.P32","ts.P33","ts.P34","ts.P35","ts.P36","ts.P37","ts.P38","ts.P39","ts.P40",
                                                        "ts.P41","ts.P42","ts.P43","ts.P44","ts.P45","ts.P46","ts.P47","ts.P48","ts.P49","ts.P50",
                                                        "ts.P51","ts.P52","ts.P53","ts.P54","ts.P55","ts.P56","ts.P57","ts.P58","ts.P59","ts.P60",
                                                        "ts.P61","ts.P62","ts.P63","ts.P64","ts.P65","ts.P66","ts.P67","ts.P68","ts.P69","ts.P70",
                                                        "ts.P71","ts.P72","ts.P73","ts.P74","ts.P75","ts.P76","ts.P77","ts.P78","ts.P79","ts.P80",
                                                        "ts.P81","ts.P82","ts.P83","ts.P84","ts.P85","ts.P86","ts.P87","ts.P88","ts.P89","ts.P90",
                                                        "ts.P91","ts.P92","ts.P93","ts.P94","ts.P95","ts.P96","ts.P97","ts.P98","ts.P99","ts.P100",
                                                        "ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "P21.","P22.","P23.","P24.","P25.","P26.","P27.","P28.","P29.","P30.",
                                                        "P31.","P32.","P33.","P34.","P35.","P36.","P37.","P38.","P39.","P40.",
                                                        "P41.","P42.","P43.","P44.","P45.","P46.","P47.","P48.","P49.","P50.",
                                                        "P51.","P52.","P53.","P54.","P55.","P56.","P57.","P58.","P59.","P60.",
                                                        "P61.","P62.","P63.","P64.","P65.","P66.","P67.","P68.","P69.","P70.",
                                                        "P71.","P72.","P73.","P74.","P75.","P76.","P77.","P78.","P79.","P80.",
                                                        "P81.","P82.","P83.","P84.","P85.","P86.","P87.","P88.","P89.","P90.",
                                                        "P91.","P92.","P93.","P94.","P95.","P96.","P97.","P98.","P99.","P100.",
                                                        "k.","alpha.","beta."),sort(rep(fleet.name,3+p)),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par.names),length(par.names));
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48),~exp(x49),~exp(x50),
                                                                      ~exp(x51),~exp(x52),~exp(x53),~exp(x54),~exp(x55),
                                                                      ~exp(x56),~exp(x57),~exp(x58),~exp(x59),~exp(x60),
                                                                      ~exp(x61),~exp(x62),~exp(x63),~exp(x64),~exp(x65),
                                                                      ~exp(x66),~exp(x67),~exp(x68),~exp(x69),~exp(x70),
                                                                      ~exp(x71),~exp(x72),~exp(x73),~exp(x74),~exp(x75),
                                                                      ~exp(x76),~exp(x77),~exp(x78),~exp(x79),~exp(x80),
                                                                      ~exp(x81),~exp(x82),~exp(x83),~exp(x84),~exp(x85),
                                                                      ~exp(x86),~exp(x87),~exp(x88),~exp(x89),~exp(x90),
                                                                      ~exp(x91),~exp(x92),~exp(x93),~exp(x94),~exp(x95),
                                                                      ~exp(x96),~exp(x97),~exp(x98),~exp(x99),~exp(x100),
                                                                      ~exp(x101),~exp(x102),~exp(x103),~exp(x104),~exp(x105)),                                                                      
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev   <- sqrt(diag(v));
                       results2[[i]]$Cor        <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else 
                {
                 stop("Parameter p -number of perturbations- does not correspond with any of the allowed integers for one fleet, -20<=p<=100")
                }
            } #Fleet 1
          else if(length(fleet.name) == 2)
            {
             if(sum(sort(dates[1:(p[1]+1)]) == dates[1:(p[1]+1)]) < length(dates[1:(p[1]+1)]) || sum(sort(dates[(p[1]+2):(p[1]+p[2]+2)]) == dates[(p[1]+2):(p[1]+p[2]+2)]) < length(dates[(p[1]+2):(p[1]+p[2]+2)]))
               {stop("Perturbation dates for each fleet should be arranged in ascending order")}
#             if(length(unique(dates[1:(p[1]+1)])) != length(dates[1:(p[1]+1)]) || length(unique(dates[(p[1]+2):(p[1]+p[2]+2)])) != length(dates[(p[1]+2):(p[1]+p[2]+2)]))   
#               {stop("Perturbation dates inside each fleet should be all distinct and distinct from initial and final date")}
             if(length(p) != 2) {stop("For a 2-fleet model 'p' must be of length 2")}
             #0P0P
             if(p[1] == 0 & p[2] == 0)
                {
                 if(length(par) != 8) {stop("For a 2-Fleet 0P 0P (pure depletion) model 'par' must be a vector of length 8")}
                 if(length(dates) != 2) {stop("For a 2-fleet 0P 0P (pure depletion) model 'dates' must be a vector of length 2")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.end");
                    par.names                      <- c("M","N0",paste(rep(c("k.","alpha.","beta."),2),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE) 
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #0P1P
             else if(p[1] == 0 & p[2] == 1)  
                {
                 if(length(par) != 9) {stop("For a 2-Fleet 0P 1P (pure depletion) model 'par' must be a vector of length 9")}
                 if(length(dates) != 3) {stop("For a 2-fleet 0P 1P (pure depletion) model 'dates' must be a vector of length 3")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F2","ts.end");
                    par.names                      <- c("M","N0",paste(c("k.","alpha.","beta.","P1.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #0P2P 
             else if(p[1] == 0 & p[2] == 2)
                {
                 if(length(par) != 10) {stop("For a 2-Fleet 0P 2P model 'par' must be a vector of length 10")}
                 if(length(dates) != 4) {stop("For a 2-Fleet 0P 2P model 'dates' must be a vector of length 4")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F2","ts.P2F2","ts.end");
                    par.names                      <- c("M","N0",paste(c("k.","alpha.","beta.","P1.","P2.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #0P3P
             else if(p[1] == 0 & p[2] == 3)
                {
                 if(length(par) != 11) {stop("For a 2-Fleet 0P 3P model M 'par' must be a vector of length 11")}
                 if(length(dates) != 5) {stop("For a 2-Fleet 0P 3P model 'dates' must be a vector of length 5")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F2","ts.P2F2","ts.P3F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("k.","alpha.","beta.","P1.","P2.","P3.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #0P4P
             else if (p[1] == 0 & p[2] == 4)
                {
                 if(length(par) != 12) {stop("For a 2-Fleet 0P 4P model 'par' must be a vector of length 12")}
                 if(length(dates) != 6) {stop("For a 2-Fleet 0P 4P model 'dates' must be a vector of length 6")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("k.","alpha.","beta.","P1.","P2.","P3.","P4.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #0P5P
             else if (p[1] == 0 & p[2] == 5)
                {
                 if(length(par) != 13) {stop("For a 2-Fleet 0P 5P model 'par' must be a vector of length 13")}
                 if(length(dates) != 7) {stop("For a 2-Fleet 0P 5P model 'dates' must be a vector of length 7")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("k.","alpha.","beta.","P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
              #1P1P
              else if (p[1] == 1 & p[2] == 1)
                {
                 if(length(par) != 10) {stop("For a 2-Fleet 1P 1P model 'par' must be a vector of length 10")}
                 if(length(dates) != 4) {stop("For a 2-Fleet 1P 1P model 'dates' must be a vector of length 4")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P1F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta.","P1.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10)),
                                                               mean=as.numeric(results1[i,1:length(par)]),
                                                               cov=try(solve(temp[i,]$nhatend)),
                                                               ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #1P2P
             else if (p[1] == 1 & p[2] == 2)
                {
                 if(length(par) != 11) {stop("For a 2-Fleet 1P 2P model 'par' must be a vector of length 11")}
                 if(length(dates) != 5) {stop("For a 2-Fleet 1P 2P model 'dates' must be a vector of length 5")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P1F2","ts.P2F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta.","P1.","P2.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #1P3P
             else if (p[1] == 1 & p[2] == 3)
                {
                 if(length(par) != 12) {stop("For a 2-Fleet 1P 3P model 'par' must be a vector of length 12")}
                 if(length(dates) != 6) {stop("For a 2-Fleet 1P 3P model 'dates' must be a vector of length 6")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.end");
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta.","P1.","P2.","P3.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                  }
                 rm(v);
                 rm(temp);
                }
             #1P4P
             else if (p[1] == 1 & p[2] == 4)
                {
                 if(length(par) != 13) {stop("For a 2-Fleet 1P 4P model 'par' must be a vector of length 13")}
                 if(length(dates) != 7) {stop("For a 2-Fleet 1P 4P model 'dates' must be a vector of length 7")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta.","P1.","P2.","P3.","P4.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                  }
                 rm(v);
                 rm(temp);
                }
             else if (p[1] == 1 & p[2] == 5)
                {
                 if(length(par) != 14) {stop("For a 2-Fleet 1P 5P model 'par' must be a vector of length 14")}
                 if(length(dates) != 8) {stop("For a 2-Fleet 1P 5P model 'dates' must be a vector of length 8")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","k.","alpha.","beta.","P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                  }
                 rm(v);
                 rm(temp);
                }
            #2P2P
             else if (p[1] == 2 & p[2] == 2)
                {
                 if(length(par) != 12) {stop("For a 2-Fleet 2P 2P model 'par' must be a vector of length 12")}
                 if(length(dates) != 6) {stop("For a 2-Fleet 2P 2P model 'dates' must be a vector of length 6")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P1F2","ts.P2F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","k.","alpha.","beta.","P1.","P2.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
            #2P3P
             else if (p[1] == 2 & p[2] == 3)
                {
                 if(length(par) != 13) {stop("For a 2-Fleet 2P 3P model 'par' must be a vector of length 13")}
                 if(length(dates) != 7) {stop("For a 2-Fleet 2P 3P model 'dates' must be a vector of length 7")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","k.","alpha.","beta.","P1.","P2.","P3.","k.","alpha.","beta."),
                                                        c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #2P4P
             else if (p[1] == 2 & p[2] == 4)
                {
                 if(length(par) != 14) {stop("For a 2-Fleet 2P 4P model 'par' must be a vector of length 14")}
                 if(length(dates) != 8) {stop("For a 2-Fleet 2P 4P model 'dates' must be a vector of length 8")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","k.","alpha.","beta.","P1.","P2.","P3.","P4.","k.","alpha.",
                                                        "beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #2P5P
             else if (p[1] == 2 & p[2] == 5)
                {
                 if(length(par) != 15) {stop("For a 2-Fleet 2P 5P model 'par' must be a vector of length 15")}
                 if(length(dates) != 9) {stop("For a 2-Fleet 2P 5P model 'dates' must be a vector of length 9")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P1F2","ts.P2F2","ts.P3F2",
                                                        "ts.P4F2","ts.P5F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","k.","alpha.","beta.","P1.","P2.",
                                                                         "P3.","P4.","P5.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                 }
             #3P3P
             else if (p[1] == 3 & p[2] == 3)
                {
                 if(length(par) != 14) {stop("For a 2-Fleet 3P 3P model 'par' must be a vector of length 14")}
                 if(length(dates) != 8) {stop("For a 2-Fleet 3P 3P model 'dates' must be a vector of length 8")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","k.","alpha.","beta.","P1.","P2.","P3.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #3P4P
             else if (p[1] == 3 & p[2] == 4)
                {
                 if(length(par) != 15) {stop("For a 2-Fleet 3P 4P model 'par' must be a vector of length 15")}
                 if(length(dates) != 9) {stop("For a 2-Fleet 3P 4P model 'dates' must be a vector of length 9")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","k.","alpha.","beta.","P1.","P2.","P3.","P4.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v)
                 rm(temp);
                }
             #3P5P
             else if (p[1] == 3 & p[2] == 5)
                {
                 if(length(par) != 16) {stop("For a 2-Fleet 3P 5P model 'par' must be a vector of length 16")}
                 if(length(dates) != 10) {stop("For a 2-Fleet 3P 5P model 'dates' must be a vector of length 10")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P1F2","ts.P2F2",
                                                        "ts.P3F2","ts.P4F2","ts.P5F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","k.","alpha.","beta.","P1.","P2.",
                                                        "P3.","P4.","P5.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #4P4P
             else if (p[1] == 4 & p[2] == 4)
                {
                 if(length(par) != 16) {stop("For a 2-Fleet 4P 4P model 'par' must be a vector of length 16")}
                 if(length(dates) != 10) {stop("For a 2-Fleet 4P 4P model 'dates' must be a vector of length 10")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P1F2",
                                                        "ts.P2F2","ts.P3F2","ts.P4F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #4P5P
             else if (p[1] == 4 & p[2] == 5)                                                              
                {
                 if(length(par) != 17) {stop("For a 2-Fleet 4P 5P model 'par' must be a vector of length 17")}
                 if(length(dates) != 11) {stop("For a 2-Fleet 4P 5P model 'dates' must be a vector of length 11")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P1F2",
                                                        "ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #5P5P
             else if (p[1] == 5 & p[2] == 5)                                                              
                {
                 if(length(par) != 18) {stop("For a 2-Fleet 5P 5P model 'par' must be a vector of length 18")}
                 if(length(dates) != 12) {stop("For a 2-Fleet 5P 5P model 'dates' must be a vector of length 12")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #6P6P
             else if (p[1] == 6 & p[2] == 6)                                                              
                {
                 if(length(par) != 20) {stop("For a 2-Fleet 6P 6P model 'par' must be a vector of length 20")}
                 if(length(dates) != 14) {stop("For a 2-Fleet 6P 6P model 'dates' must be a vector of length 14")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1","ts.P6F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #7P7P
             else if (p[1] == 7 & p[2] == 7)                                                              
                {
                 if(length(par) != 22) {stop("For a 2-Fleet 7P 7P model 'par' must be a vector of length 22")}
                 if(length(dates) != 16) {stop("For a 2-Fleet 7P 7P model 'dates' must be a vector of length 16")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #8P8P
             else if (p[1] == 8 & p[2] == 8)                                                              
                {
                 if(length(par) != 24) {stop("For a 2-Fleet 8P 8P model 'par' must be a vector of length 24")}
                 if(length(dates) != 18) {stop("For a 2-Fleet 8P 8P model 'dates' must be a vector of length 18")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #9P9P
             else if (p[1] == 9 & p[2] == 9)                                                              
                {
                 if(length(par) != 26) {stop("For a 2-Fleet 9P 9P model 'par' must be a vector of length 26")}
                 if(length(dates) != 20) {stop("For a 2-Fleet 9P 9P model 'dates' must be a vector of length 20")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #10P10P
             else if (p[1] == 10 & p[2] == 10)                                                              
                {
                 if(length(par) != 28) {stop("For a 2-Fleet 10P 10P model 'par' must be a vector of length 28")}
                 if(length(dates) != 22) {stop("For a 2-Fleet 10P 10P model 'dates' must be a vector of length 22")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #11P11P
             else if (p[1] == 11 & p[2] == 11)                                                              
                {
                 if(length(par) != 30) {stop("For a 2-Fleet 11P 11P model 'par' must be a vector of length 30")}
                 if(length(dates) != 24) {stop("For a 2-Fleet 11P 11P model 'dates' must be a vector of length 24")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #12P12P
             else if (p[1] == 12 & p[2] == 12)                                                              
                {
                 if(length(par) != 32) {stop("For a 2-Fleet 12P 12P model 'par' must be a vector of length 32")}
                 if(length(dates) != 26) {stop("For a 2-Fleet 12P 12P model 'dates' must be a vector of length 26")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #13P13P
             else if (p[1] == 13 & p[2] == 13)
                {
                 if(length(par) != 34) {stop("For a 2-Fleet 13P 13P model 'par' must be a vector of length 34")}
                 if(length(dates) != 28) {stop("For a 2-Fleet 13P 13P model 'dates' must be a vector of length 28")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             else if (p[1] == 14 & p[2] == 14)
                {
                 if(length(par) != 36) {stop("For a 2-Fleet 14P 14P model 'par' must be a vector of length 36")}
                 if(length(dates) != 30) {stop("For a 2-Fleet 14P 14P model 'dates' must be a vector of length 30")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #15P15P
             else if (p[1] == 15 & p[2] == 15)
                {
                 if(length(par) != 38) {stop("For a 2-Fleet 15P 15P model 'par' must be a vector of length 38")}
                 if(length(dates) != 32) {stop("For a 2-Fleet 15P 15P model 'dates' must be a vector of length 32")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.P15F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #16P16P
             else if (p[1] == 16 & p[2] == 16)
                {
                 if(length(par) != 40) {stop("For a 2-Fleet 16P 16P model 'par' must be a vector of length 40")}
                 if(length(dates) != 34) {stop("For a 2-Fleet 16P 16P model 'dates' must be a vector of length 34")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1","ts.P16F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.P15F2","ts.P16F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #17P17P
             else if (p[1] == 17 & p[2] == 17)
                {
                 if(length(par) != 42) {stop("For a 2-Fleet 17P 17P model 'par' must be a vector of length 42")}
                 if(length(dates) != 36) {stop("For a 2-Fleet 17P 17P model 'dates' must be a vector of length 36")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1","ts.P16F1",
                                                        "ts.P17F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.P15F2","ts.P16F2","ts.P17F2",
                                                        "ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
             #18P18P
             else if (p[1] == 18 & p[2] == 18)
                {
                 if(length(par) != 44) {stop("For a 2-Fleet 18P 18P model 'par' must be a vector of length 44")}
                 if(length(dates) != 38) {stop("For a 2-Fleet 18P 18P model 'dates' must be a vector of length 38")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1","ts.P16F1",
                                                        "ts.P17F1","ts.P18F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.P15F2","ts.P16F2","ts.P17F2",
                                                        "ts.P18F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
            #19P19P
            else if (p[1] == 19 & p[2] == 19)
                {
                 if(length(par) != 46) {stop("For a 2-Fleet 19P 19P model 'par' must be a vector of length 46")}
                 if(length(dates) != 40) {stop("For a 2-Fleet 19P 19P model 'dates' must be a vector of length 40")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1","ts.P16F1",
                                                        "ts.P17F1","ts.P18F1","ts.P19F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.P15F2","ts.P16F2","ts.P17F2",
                                                        "ts.P18F2","ts.P19F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","P19.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
            #20P20P
            else if (p[1] == 20 & p[2] == 20)
                {
                 if(length(par) != 48) {stop("For a 2-Fleet 20P 20P model 'par' must be a vector of length 48")}
                 if(length(dates) != 42) {stop("For a 2-Fleet 20P 20P model 'dates' must be a vector of length 42")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start","ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1","ts.P11F1",
                                                        "ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1","ts.P16F1",
                                                        "ts.P17F1","ts.P18F1","ts.P19F1","ts.P20F1",
                                                        "ts.P1F2","ts.P2F2","ts.P3F2","ts.P4F2","ts.P5F2","ts.P6F2",
                                                        "ts.P7F2","ts.P8F2","ts.P9F2","ts.P10F2","ts.P11F2","ts.P12F2",
                                                        "ts.P13F2","ts.P14F2","ts.P15F2","ts.P16F2","ts.P17F2",
                                                        "ts.P18F2","ts.P19F2","ts.P20F2","ts.end"); 
                    par.names                      <- c("M","N0",paste(c("P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.",
                                                        "P9.","P10.","P11.","P12.","P13.","P14.","P15.","P16.","P17.",
                                                        "P18.","P19.","P20.",
                                                        "k.","alpha.","beta.",
                                                        "P1.","P2.","P3.","P4.","P5.","P6.","P7.","P8.","P9.","P10.",
                                                        "P11.","P12.","P13.","P14.","P15.","P16.","P17.","P18.","P19.","P20.",
                                                        "k.","alpha.","beta."),c(rep(fleet.name[1],3+p[1]),rep(fleet.name[2],3+p[2])),sep=""));
                    if(length(temp[i,]$ngatend) < length(par.names) || any(is.na(temp[i,]$nhatend)) || 1/kappa(temp[i,]$nhatend) < 1e-15)
                      {
                       results2[[i]]$converg          <- "FAIL";
                       results2[[i]]$kkt              <- NA;
                       results2[[i]]$AIC              <- NA;
                       results2[[i]]$bt.par           <- NA;
                       results2[[i]]$num.grads        <- NA;
                       results2[[i]]$bt.stdev <- rep(NA, length(par.names))
                       results2[[i]]$Cor      <- matrix(NA,length(par.names),length(par.names))
                      }
                    else
                      {
                       results2[[i]]$converg    <- results1[i,length(par)+5];
                       results2[[i]]$kkt        <- results1[i,(length(par)+6):(length(par)+7)];
                       results2[[i]]$AIC        <- 2*length(par)-2*results1[i,length(par)+1];
                       results2[[i]]$bt.par     <- exp(results1[i,1:length(par)])
                       results2[[i]]$num.grads  <- temp[i,]$ngatend;
                                             v  <- matrix(0,length(par),length(par))
                                             v  <- deltamethod(g=list(~exp(x1),~exp(x2),~exp(x3),~exp(x4),~exp(x5),
                                                                      ~exp(x6),~exp(x7),~exp(x8),~exp(x9),~exp(x10),
                                                                      ~exp(x11),~exp(x12),~exp(x13),~exp(x14),~exp(x15),
                                                                      ~exp(x16),~exp(x17),~exp(x18),~exp(x19),~exp(x20),
                                                                      ~exp(x21),~exp(x22),~exp(x23),~exp(x24),~exp(x25),
                                                                      ~exp(x26),~exp(x27),~exp(x28),~exp(x29),~exp(x30),
                                                                      ~exp(x31),~exp(x32),~exp(x33),~exp(x34),~exp(x35),
                                                                      ~exp(x36),~exp(x37),~exp(x38),~exp(x39),~exp(x40),
                                                                      ~exp(x41),~exp(x42),~exp(x43),~exp(x44),~exp(x45),
                                                                      ~exp(x46),~exp(x47),~exp(x48)),
                                                                mean=as.numeric(results1[i,1:length(par)]),
                                                                cov=try(solve(temp[i,]$nhatend)),
                                                                ses=FALSE)
                       results2[[i]]$bt.stdev         <- sqrt(diag(v));
                       results2[[i]]$Cor              <- cor(v);
                       names(results2[[i]]$num.grads) <- par.names;
                       names(results2[[i]]$bt.par)    <- par.names;
                       names(results2[[i]]$bt.stdev)  <- par.names;
                       colnames(results2[[i]]$Cor)    <- par.names;
                       rownames(results2[[i]]$Cor)    <- par.names;
                      }
                   }
                 rm(v);
                 rm(temp);
                }
            else if (p[1] == 21 & p[2] == 21)
                {
                 if(length(par) != 50) {stop("For a 2-Fleet 21P 21P model 'par' must be a vector of length 50")}
                 if(length(dates) != 44) {stop("For a 2-Fleet 21P 21P model 'dates' must be a vector of length 44")}
                 results1        <- do.call(optimx, list(par=par, 
                                                         fn=eval(as.name(paste('.CDMN',as.character(p[1]),'P',as.character(p[2]),'P',sep=""))),
                                                         gr=NULL, 
                                                         dates=dates, 
                                                         obseff1=x$Data[[fleet.name[1]]][,2], 
                                                         obscat1=x$Data[[fleet.name[1]]][,5], 
                                                         obseff2=x$Data[[fleet.name[2]]][,2], 
                                                         obscat2=x$Data[[fleet.name[2]]][,5], 
                                                         distr=distr, 
                                                         method=method, 
                                                         lower = -Inf, 
                                                         upper = Inf, 
                                                         control=list(), 
                                                         hessian=hessian,
                                                         itnmax=itnmax,
                                                         output="estimate"));
                 results2        <- vector("list",length(method));
                 names(results2) <- method;
                 temp            <- attr(results1, "details")
                 for(i in 1:length(method))
                   {
                    results2[[i]]$Type       <- p;
                    results2[[i]]$Dates      <- dates;
                    results2[[i]]$Distr      <- distr;
                    names(results2[[i]]$Dates)     <- c("ts.start",
                                                        "ts.P1F1","ts.P2F1","ts.P3F1","ts.P4F1","ts.P5F1",
                                                        "ts.P6F1","ts.P7F1","ts.P8F1","ts.P9F1","ts.P10F1",
                                                        "ts.P11F1","ts.P12F1","ts.P13F1","ts.P14F1","ts.P15F1",
                                                        "