% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikcube_1.R
\name{loglikCUBE}
\alias{loglikCUBE}
\title{Log-likelihood function for CUBE models}
\usage{
loglikCUBE(ordinal,m,param,Y=0,W=0,Z=0)
}
\arguments{
\item{ordinal}{Vector of ordinal responses (factor type)}

\item{m}{Number of ordinal categories}

\item{param}{Vector of parameters for the specified CUBE model}

\item{Y}{Matrix of selected covariates to explain the uncertainty component (default: no covariate is included 
in the model)}

\item{W}{Matrix of selected covariates to explain the feeling component (default: no covariate is included 
in the model)}

\item{Z}{Matrix of selected covariates to explain the overdispersion component (default: no covariate is included 
in the model)}
}
\description{
Compute the log-likelihood function for CUBE models. It is possible to include 
 covariates in the model for explaining the feeling component or all the three parameters.
}
\details{
If no covariate is included in the model, then \code{param} has the form \eqn{(\pi,\xi,\phi)}. More generally, 
it has the form \eqn{(\bold{\beta,\gamma,\alpha)}} where, respectively, \eqn{\bold{\beta}},\eqn{\bold{\gamma}}, \eqn{\bold{\alpha}}
 are the vectors of  coefficients explaining the uncertainty, the feeling and the overdispersion components, with length NCOL(Y)+1, 
 NCOL(W)+1, NCOL(Z)+1 to account for an intercept term in the first entry.
}
\examples{
#### Log-likelihood of a CUBE model with no covariate
m<-7; n<-400
pai<-0.83; csi<-0.19; phi<-0.045
ordinal<-simcube(n,m,pai,csi,phi)
loglik<-loglikCUBE(ordinal,m,param=c(pai,csi,phi))
##################################
#### Log-likelihood of a CUBE model with covariate for feeling
data(relgoods)
attach(relgoods)
m<-10
nacov<-which(is.na(BirthYear))
naord<-which(is.na(Tv))
na<-union(nacov,naord)
age<-2014-BirthYear[-na]
lage<-log(age)-mean(log(age))
ordinal<-Tv[-na]; W<-lage
pai<-0.63; gama<-c(-0.61,-0.31); phi<-0.16
param<-c(pai,gama,phi)
loglik<-loglikCUBE(ordinal,m,param,W=W)
########## Log-likelihood of a CUBE model with covariates for all parameters
Y<-W<-Z<-lage
bet<-c(0.18, 1.03); gama<-c(-0.6, -0.3); alpha<-c(-2.3,0.92)
param<-c(bet,gama,alpha)
loglik<-loglikCUBE(ordinal,m,param,Y=Y,W=W,Z=Z)
}
\seealso{
\code{\link{logLik}}
}
\keyword{htest}

