% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.diffuseP1.r
\name{graph.diffuseP1}
\alias{graph.diffuseP1}
\title{Diffuse Probability P1 from a starting node}
\usage{
graph.diffuseP1(p1,sn,G,vNodes,thresholdDiff,adj_mat,verbose=FALSE,
                        out_dir="",r_level=1,coords=NULL)
}
\arguments{
\item{p1}{- The probability being dispersed from the starting node, 
sn, which is preferentially distributed between 
network nodes by the probability diffusion algorithm 
based solely on network connectivity.}

\item{sn}{- "Start node", or the node most recently visited by the
network walker, from which p1 gets dispersed.}

\item{G}{- A list of probabilities, with names of the list being the 
node names in the network.}

\item{vNodes}{- "Visited nodes", or the history of previous draws
in the node ranking sequence.}

\item{thresholdDiff}{- When the probability diffusion algorithm exchanges
this amount (thresholdDiff) or less between nodes, 
the algorithm returns up the call stack.}

\item{adj_mat}{- The adjacency matrix that encodes the edge weights for
the network, G.}

\item{verbose}{- If debugging or tracking a diffusion event, verbose=TRUE
will activate print statements. Default is FALSE.}

\item{out_dir}{- If specified, a image sequence will generate in the
output directory specified.}

\item{r_level}{- "Recursion level", or the current depth in the call stack 
caused by a recursive algorithm. Only relevant if out_dir
is specified.}

\item{coords}{- The x and y coordinates for each node in the network, to
remain static between images. Only relevant if out_dir
is specified.}
}
\value{
G - A list of returned probabilities after the diffusion of
probability has truncated, with names of the list being the node names
in the network.
}
\description{
Recursively diffuse probability from a starting node based on the
connectivity of the network, representing the likelihood that a 
variable is most influenced by a perturbation in the starting node.
}
\examples{
# Read in any network via its adjacency matrix
adj_mat=rbind(c(0,1,2,0,0,0,0,0,0), #A's neighbors
                c(1,0,3,0,0,0,0,0,0), #B's neighbors
                c(2,3,0,0,1,0,0,0,0), #C's neighbors
                c(0,0,0,0,0,0,1,1,0), #D's neighbors
                c(0,0,1,0,0,1,0,0,0), #E's neighbors
                c(0,0,0,0,1,0,0,0,0), #F's neighbors
                c(0,0,0,1,0,0,0,1,0), #G's neighbors
                c(0,0,0,1,0,0,1,0,0), #H's neighbors
                c(0,0,0,0,0,0,0,0,0) #I's neighbors
                )
rownames(adj_mat)=c("A","B","C","D","E","F","G","H","I")
colnames(adj_mat)=c("A","B","C","D","E","F","G","H","I")
G=vector(mode="list", length=ncol(adj_mat))
names(G)=colnames(adj_mat)
G=lapply(G, function(i) i[[1]]=0)
probs_afterCurrDraw=graph.diffuseP1(p1=1.0, sn=names(G)[1], G=G,
                                    vNodes=names(G)[1], 
                                    thresholdDiff=0.01, adj_mat, TRUE)
}
\keyword{diffusion}
\keyword{network}
\keyword{probability}
\keyword{walker}
