% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_ChangeDimNames.R
\name{CST_ChangeDimNames}
\alias{CST_ChangeDimNames}
\title{Change the name of one or more dimensions for an object of class s2dv_cube}
\usage{
CST_ChangeDimNames(data, original_names, new_names)
}
\arguments{
\item{data}{An object of class \code{s2dv_cube} whose dimension names
should be changed.}

\item{original_names}{A single character string or a vector indicating the 
dimensions to be renamed.}

\item{new_names}{A single character string or a vector indicating the new
dimension names, in the same order as the dimensions in 'original_names'.}
}
\value{
An object of class \code{s2dv_cube} with similar data, coordinates and 
attributes as the \code{data} input, but with modified dimension names.
}
\description{
Change the names of the dimensions specified in 'original_names' to the names
in 'new_names'. The coordinate names and the dimensions of any attributes
are also modified accordingly.
}
\examples{
# Example with sample data:
# Check original dimensions and coordinates
lonlat_temp$exp$dims
names(lonlat_temp$exp$coords)
dim(lonlat_temp$exp$attrs$Dates)
# Change 'dataset' to 'dat' and 'ftime' to 'time'
exp <- CST_ChangeDimNames(lonlat_temp$exp,
                         original_names = c("dataset", "ftime"),
                         new_names = c("dat", "time"))
# Check new dimensions and coordinates
exp$dims
names(exp$coords)
dim(exp$attrs$Dates)

}
\author{
Agudetse Roures Victoria, \email{victoria.agudetse@bsc.es}
}
