% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_structure.R
\docType{methods}
\name{CSanalysis,matrix,matrix,CSfabia-method}
\alias{CSanalysis,matrix,matrix,CSfabia-method}
\title{"CSfabia"}
\usage{
\S4method{CSanalysis}{matrix,matrix,CSfabia}(querMat, refMat,
  type = "CSfabia", p = 13, alpha = 0.01, cyc = 500, spl = 0,
  spz = 0.5, non_negative = 0, random = 1, center = 2, norm = 1,
  scale = 0, lap = 1, nL = 0, lL = 0, bL = 0, which = c(2, 3, 4, 5),
  component.plot = NULL, CSrank.queryplot = FALSE, column.interest = NULL,
  row.interest = NULL, profile.type = "gene", color.columns = NULL,
  gene.highlight = NULL, gene.thresP = 1, gene.thresN = -1,
  thresP.col = "blue", thresN.col = "red", grouploadings.labels = NULL,
  grouploadings.cutoff = NULL, legend.names = NULL, legend.cols = NULL,
  legend.pos = "topright", labels = TRUE, result.available = NULL,
  result.available.update = FALSE, plot.type = "device",
  basefilename = NULL)
}
\arguments{
\item{querMat}{Query matrix (Rows = genes and columns = compounds)}

\item{refMat}{Reference matrix}

\item{type}{\code{"CSfabia"}}

\item{p}{\emph{Fabia Parameter:} number of hidden factors = number of biclusters; default = 13}

\item{alpha}{\emph{Fabia Parameter:} sparseness loadings (0 - 1.0); default = 0.01}

\item{cyc}{\emph{Fabia Parameter:} number of iterations; default = 500}

\item{spl}{\emph{Fabia Parameter:} sparseness prior loadings (0 - 2.0); default = 0 (Laplace)}

\item{spz}{\emph{Fabia Parameter:} sparseness factors (0.5 - 2.0); default = 0.5 (Laplace)}

\item{non_negative}{\emph{Fabia Parameter:} Non-negative factors and loadings if non_negative > 0; default = 0}

\item{random}{\emph{Fabia Parameter:} <=0: by SVD, >0: random initialization of loadings in [-random,random]; default = 1.0}

\item{center}{\emph{Fabia Parameter:} data centering: 1 (mean), 2 (median), > 2 (mode), 0 (no); default = 2}

\item{norm}{\emph{Fabia Parameter:} data normalization: 1 (0.75-0.25 quantile), >1 (var=1), 0 (no); default = 1}

\item{scale}{\emph{Fabia Parameter:} loading vectors are scaled in each iteration to the given variance. 0.0 indicates non scaling; default = 0.0}

\item{lap}{\emph{Fabia Parameter:} minimal value of the variational parameter; default = 1.0}

\item{nL}{\emph{Fabia Parameter:} maximal number of biclusters at which a row element can participate; default = 0 (no limit)}

\item{lL}{\emph{Fabia Parameter:} maximal number of row elements per bicluster; default = 0 (no limit)}

\item{bL}{\emph{Fabia Parameter:} cycle at which the nL or lL maximum starts; default = 0 (start at the beginning)}

\item{which}{Choose one or more plots to draw: 
\enumerate{
\item Information Content for Bicluster (Only available for "CSfabia")
\item Loadings for query compounds
\item Loadings for Component (Factor/Bicluster) \code{component.plot}
\item Gene Scores for Component (Factor/Bicluster) \code{component.Plot}
\item Connectivity Ranking Scores for Component \code{component.plot}
\item Component \code{component.plot} VS Other Component : Loadings & Genes 
\item Profile plot (see \code{profile.type})
\item Group Loadings Plots for all components (see \code{grouploadings.labels}).
}}

\item{component.plot}{Which components (Factor/Bicluster) should be investigated? Can be a vector of multiple (e.g. \code{c(1,3,5)}). If \code{NULL}, you can choose components of interest interactively from query loadings plot.}

\item{CSrank.queryplot}{Logical value deciding if the CS Rank Scores (\code{which=5}) should also be plotted per query (instead of only the weighted mean).}

\item{column.interest}{Numeric vector of indices of reference columns which should be in the profiles plots (\code{which=7}). If \code{NULL}, you can interactively select genes on the Compound Loadings plot (\code{which=3}).}

\item{row.interest}{Numeric vector of gene indices to be plotted in gene profiles plot (\code{which=7}, \code{profile.type="gene"}). If \code{NULL}, you can interactively select them in the gene scores plot (\code{which=4}).}

\item{profile.type}{Type of \code{which=7} plot:
\itemize{
\item \code{"gene"}: Gene profiles plot of selected genes in \code{row.interest} with the query compounds and those selected in \code{column.interest} ordered first on the x axis. The other compounds are ordered in decreasing CScore. 
\item \code{"cmpd"}: Compound profiles plot of query and selected compounds (\code{column.interest}) and only those genes on the x-axis which beat the thresholds (\code{gene.thresP}, \code{gene.thresN})
}}

\item{color.columns}{Vector of colors for the query and reference columns (compounds). If \code{NULL}, blue will be used for query and black for reference. Use this option to highlight query columns and reference columns of interest.}

\item{gene.highlight}{Single numeric vector or list of maximum 5 numeric vectors. This highlights gene of interest in gene scores plot (\code{which=4}) up to 5 different colors. (e.g. You can use this to highlight genes you know to be differentially expressed)}

\item{gene.thresP}{Threshold for genes with a high score (\code{which=4}).}

\item{gene.thresN}{Threshold for genes with a low score (\code{which=4}).}

\item{thresP.col}{Color of genes above \code{gene.thresP}.}

\item{thresN.col}{Color of genes below \code{gene.thresN}.}

\item{grouploadings.labels}{This parameter used for the Group Loadings Plots (\code{which=8}). In general this plot will contain the loadings of all factors, grouped and colored by the labels given in this parameter. Two types of plot can be created:
\enumerate{
\item If \code{grouploadings.labels!=NULL}:\cr
Provide a vector for all samples (query + ref) containing labels on which the plot will be based on.

\item If \code{grouploadings.labels=NULL}: \cr
If no labels are provided when choosing \code{which=8}, automatic labels ("Top Samples of Component 1, 2....") will be created. These labels are given to the top \code{grouploadings.cutoff}  number of samples based on the absolute values of the loadings. 
}
Plot \code{which=8} can be used to check 2 different situations. The first plot checks if your provided labels coincide with the discovered structures in the analysis. The second plot aims to find new interesting structures (of samples) which strongly appear in one or multiple components. A subsequent step could be to take some strong samples/compounds of these compounds and use them as a new query set in a new CS analysis to check its validity or to find newly connected compounds.

Please note that even when \code{group.loadings.labels!=NULL}, that the labels based on the absolute loadings of all the factors (the top \code{grouploadings.cutoff}) will always be generated and saved in \code{samplefactorlabels} in the \code{extra} slot of the \code{CSresult} object. 
This can then later be used for the \code{\link{CSlabelscompare}} function to compare them with your true labels.}

\item{grouploadings.cutoff}{Parameter used in plot \code{which=8}. An integer for the number of cut-offs. See \code{grouploadings.labels=NULL} for more information. If this parameter is not provided, it will be automatically set to 10\% of the total number of loadings.}

\item{legend.names}{Option to draw a legend of for example colored columns in Compound Loadings plot (\code{which=3}). If \code{NULL}, only "References" will be in the legend.}

\item{legend.cols}{Colors to be used in legends. If \code{NULL}, only blue for "Queries is used".}

\item{legend.pos}{Position of the legend in all requested plots, can be \code{"topright"}, \code{"topleft"}, \code{"bottomleft"}, \code{"bottomright"}, \code{"bottom"}, \code{"top"}, \code{"left"}, \code{"right"}, \code{"center"}.}

\item{labels}{Boolean value (default=TRUE) to use row and/or column text labels in the score plots (\code{which=c(3,4,5,6)}).}

\item{result.available}{You can a previously returned object by \code{CSanalysis} in order to only draw graphs, not recompute the scores.}

\item{result.available.update}{Logical value. If \code{TRUE}, the CS and GS will be overwritten depending on the new \code{component.plot} choice. This would also delete the p-values if \code{permutation.object} was available.}

\item{plot.type}{How should the plots be outputted? \code{"pdf"} to save them in pdf files, \code{device} to draw them in a graphics device (default), \code{sweave} to use them in a sweave or knitr file.}

\item{basefilename}{Directory including filename of the graphs if saved in pdf files}
}
\value{
An object of the S4 Class \code{\link{CSresult-class}}.
}
\description{
Doing interactive CS analysis with FABIA (Factor Analysis for Bicluster Acquisition). One or multiple query compounds are possible in this analysis.
}
